/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.reaction;

import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import ch.admin.bit.jeap.archrepo.metamodel.reaction.Action;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
public class ReactionStatistics
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="component_id")
    private SystemComponent component;
    private String triggerType;
    private String triggerFqn;
    private int count;
    private Double median;
    private Double percentage;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="reactionStatistics")
    private List<Action> actions = new ArrayList<Action>();

    public void addAction(Action action) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        action.setReactionStatistics(this);
        this.actions.add(action);
    }

    protected ReactionStatistics() {
    }

    public ReactionStatistics(SystemComponent component, String triggerType, String triggerFqn, int count, Double median, Double percentage) {
        this.id = Generators.timeBasedEpochGenerator().generate();
        this.component = component;
        this.triggerType = triggerType;
        this.triggerFqn = triggerFqn;
        this.count = count;
        this.median = median;
        if (triggerType != null) {
            this.percentage = percentage;
        }
    }

    @Generated
    public static ReactionStatisticsBuilder builder() {
        return new ReactionStatisticsBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReactionStatistics)) {
            return false;
        }
        ReactionStatistics other = (ReactionStatistics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        Double this$median = this.getMedian();
        Double other$median = other.getMedian();
        if (this$median == null ? other$median != null : !((Object)this$median).equals(other$median)) {
            return false;
        }
        Double this$percentage = this.getPercentage();
        Double other$percentage = other.getPercentage();
        if (this$percentage == null ? other$percentage != null : !((Object)this$percentage).equals(other$percentage)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$triggerType = this.getTriggerType();
        String other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !this$triggerType.equals(other$triggerType)) {
            return false;
        }
        String this$triggerFqn = this.getTriggerFqn();
        String other$triggerFqn = other.getTriggerFqn();
        if (this$triggerFqn == null ? other$triggerFqn != null : !this$triggerFqn.equals(other$triggerFqn)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReactionStatistics;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCount();
        Double $median = this.getMedian();
        result = result * 59 + ($median == null ? 43 : ((Object)$median).hashCode());
        Double $percentage = this.getPercentage();
        result = result * 59 + ($percentage == null ? 43 : ((Object)$percentage).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : $triggerType.hashCode());
        String $triggerFqn = this.getTriggerFqn();
        result = result * 59 + ($triggerFqn == null ? 43 : $triggerFqn.hashCode());
        List<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReactionStatistics(id=" + String.valueOf(this.getId()) + ", triggerType=" + this.getTriggerType() + ", triggerFqn=" + this.getTriggerFqn() + ", count=" + this.getCount() + ", median=" + this.getMedian() + ", percentage=" + this.getPercentage() + ", actions=" + String.valueOf(this.getActions()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public SystemComponent getComponent() {
        return this.component;
    }

    @Generated
    public String getTriggerType() {
        return this.triggerType;
    }

    @Generated
    public String getTriggerFqn() {
        return this.triggerFqn;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public Double getMedian() {
        return this.median;
    }

    @Generated
    public Double getPercentage() {
        return this.percentage;
    }

    @Generated
    public List<Action> getActions() {
        return this.actions;
    }

    @Generated
    public void setComponent(SystemComponent component) {
        this.component = component;
    }

    @Generated
    public static class ReactionStatisticsBuilder {
        @Generated
        private SystemComponent component;
        @Generated
        private String triggerType;
        @Generated
        private String triggerFqn;
        @Generated
        private int count;
        @Generated
        private Double median;
        @Generated
        private Double percentage;

        @Generated
        ReactionStatisticsBuilder() {
        }

        @Generated
        public ReactionStatisticsBuilder component(SystemComponent component) {
            this.component = component;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder triggerFqn(String triggerFqn) {
            this.triggerFqn = triggerFqn;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder count(int count) {
            this.count = count;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder median(Double median) {
            this.median = median;
            return this;
        }

        @Generated
        public ReactionStatisticsBuilder percentage(Double percentage) {
            this.percentage = percentage;
            return this;
        }

        @Generated
        public ReactionStatistics build() {
            return new ReactionStatistics(this.component, this.triggerType, this.triggerFqn, this.count, this.median, this.percentage);
        }

        @Generated
        public String toString() {
            return "ReactionStatistics.ReactionStatisticsBuilder(component=" + String.valueOf(this.component) + ", triggerType=" + this.triggerType + ", triggerFqn=" + this.triggerFqn + ", count=" + this.count + ", median=" + this.median + ", percentage=" + this.percentage + ")";
        }
    }
}

