/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.metamodel.system;

import ch.admin.bit.jeap.archrepo.metamodel.MutableDomainEntity;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="system_graph")
public class SystemGraph
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @NotNull
    @Column(name="system_name")
    private String systemName;
    @Lob
    @JdbcTypeCode(value=-2)
    @Column(name="graph_data", columnDefinition="BYTEA")
    private byte[] graphData;
    private String fingerprint;

    protected SystemGraph() {
    }

    public SystemGraph(String systemName, byte[] graphData, String fingerprint) {
        this.id = Generators.timeBasedEpochGenerator().generate();
        this.systemName = systemName;
        this.graphData = graphData;
        this.fingerprint = fingerprint;
    }

    @Generated
    public static SystemGraphBuilder builder() {
        return new SystemGraphBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemGraph)) {
            return false;
        }
        SystemGraph other = (SystemGraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$systemName = this.getSystemName();
        String other$systemName = other.getSystemName();
        if (this$systemName == null ? other$systemName != null : !this$systemName.equals(other$systemName)) {
            return false;
        }
        if (!Arrays.equals(this.getGraphData(), other.getGraphData())) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        return !(this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SystemGraph;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $systemName = this.getSystemName();
        result = result * 59 + ($systemName == null ? 43 : $systemName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getGraphData());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SystemGraph(id=" + String.valueOf(this.getId()) + ", systemName=" + this.getSystemName() + ", graphData=" + Arrays.toString(this.getGraphData()) + ", fingerprint=" + this.getFingerprint() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getSystemName() {
        return this.systemName;
    }

    @Generated
    public byte[] getGraphData() {
        return this.graphData;
    }

    @Generated
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Generated
    public static class SystemGraphBuilder {
        @Generated
        private String systemName;
        @Generated
        private byte[] graphData;
        @Generated
        private String fingerprint;

        @Generated
        SystemGraphBuilder() {
        }

        @Generated
        public SystemGraphBuilder systemName(String systemName) {
            this.systemName = systemName;
            return this;
        }

        @Generated
        public SystemGraphBuilder graphData(byte[] graphData) {
            this.graphData = graphData;
            return this;
        }

        @Generated
        public SystemGraphBuilder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        @Generated
        public SystemGraph build() {
            return new SystemGraph(this.systemName, this.graphData, this.fingerprint);
        }

        @Generated
        public String toString() {
            return "SystemGraph.SystemGraphBuilder(systemName=" + this.systemName + ", graphData=" + Arrays.toString(this.graphData) + ", fingerprint=" + this.fingerprint + ")";
        }
    }
}

