/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.reaction;

import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.junit5.PactConsumerTestExt;
import au.com.dius.pact.consumer.junit5.PactTestFor;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.annotations.Pact;
import ch.admin.bit.jeap.archrepo.importer.reaction.ReactionObserverServiceProperties;
import ch.admin.bit.jeap.archrepo.importer.reaction.ReactionsObserverImporterConfiguration;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.ActionDto;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.ReactionObserverService;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.ReactionsObservedStatisticsDto;
import java.util.Base64;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={PactConsumerTestExt.class})
@PactTestFor(port="8888", pactVersion=PactSpecVersion.V3)
public class ReactionObserverServicePactTestBase {
    private static final String API_PATH = "/api/statisticsV2";

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getStatisticsForKnownComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("Statistics for component 'c1' are available").uponReceiving("A GET request to /api/statisticsV2/c1").path("/api/statisticsV2/c1").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body("[\n  {\n    \"component\": \"c1\",\n    \"triggerType\": \"command\",\n    \"triggerFqn\": \"SomeCommand\",\n    \"actions\": [\n      {\n        \"actionType\": \"event\",\n        \"actionFqn\": \"SomeEvent\",\n        \"actionProperties\": {}\n      }\n    ],\n    \"count\": 100,\n    \"median\": 50.0,\n    \"percentage\": 75.0,\n    \"triggerProperties\": {}\n  }\n]\n").toPact();
    }

    @Test
    @PactTestFor(pactMethod="getStatisticsForKnownComponentInteraction")
    void testGetStatistics() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        List result = reactionObserverService.getReactionsObservedStatistics("c1");
        Assertions.assertThat((List)result).isNotEmpty();
        ReactionsObservedStatisticsDto statisticsDto = (ReactionsObservedStatisticsDto)result.getFirst();
        Assertions.assertThat((String)statisticsDto.component()).isEqualTo("c1");
        Assertions.assertThat((String)statisticsDto.triggerType()).isEqualTo("command");
        Assertions.assertThat((String)statisticsDto.triggerFqn()).isEqualTo("SomeCommand");
        Assertions.assertThat((List)statisticsDto.actions()).isNotEmpty();
        ActionDto action = (ActionDto)statisticsDto.actions().getFirst();
        Assertions.assertThat((String)action.actionType()).isEqualTo("event");
        Assertions.assertThat((String)action.actionFqn()).isEqualTo("SomeEvent");
        Assertions.assertThat((long)statisticsDto.count()).isGreaterThan(0L);
        Assertions.assertThat((double)statisticsDto.median()).isGreaterThan(0.0);
        Assertions.assertThat((Double)statisticsDto.percentage()).isGreaterThan(0.0);
    }

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getStatisticsForUnknownComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("Statistics for unknown component are empty").uponReceiving("A GET request to /api/statisticsV2/unknown").path("/api/statisticsV2/unknown").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body((DslPart)PactDslJsonArray.newUnorderedArray()).toPact();
    }

    @Test
    @PactTestFor(pactMethod="getStatisticsForUnknownComponentInteraction")
    void testGetStatisticsUnknownComponent() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        List result = reactionObserverService.getReactionsObservedStatistics("unknown");
        Assertions.assertThat((List)result).isEmpty();
    }
}

