/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.model;

import au.com.dius.pact.provider.junit5.HttpTestTarget;
import au.com.dius.pact.provider.junit5.PactVerificationContext;
import au.com.dius.pact.provider.junit5.PactVerificationInvocationContextProvider;
import au.com.dius.pact.provider.junit5.TestTarget;
import au.com.dius.pact.provider.junitsupport.AllowOverridePactUrl;
import au.com.dius.pact.provider.junitsupport.IgnoreNoPactsToVerify;
import au.com.dius.pact.provider.junitsupport.Provider;
import au.com.dius.pact.provider.junitsupport.State;
import au.com.dius.pact.provider.junitsupport.loader.PactBroker;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.database.SystemComponentDatabaseSchema;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.model.database.DatabaseSchema;
import ch.admin.bit.jeap.archrepo.model.database.Table;
import ch.admin.bit.jeap.archrepo.model.database.TableColumn;
import ch.admin.bit.jeap.archrepo.model.database.TableForeignKey;
import ch.admin.bit.jeap.archrepo.model.database.TablePrimaryKey;
import ch.admin.bit.jeap.archrepo.persistence.ApiDocVersion;
import ch.admin.bit.jeap.archrepo.persistence.ArchitectureModelRepository;
import ch.admin.bit.jeap.archrepo.persistence.OpenApiSpecRepository;
import ch.admin.bit.jeap.archrepo.persistence.SystemComponentDatabaseSchemaRepository;
import ch.admin.bit.jeap.archrepo.persistence.SystemRepository;
import ch.admin.bit.jeap.archrepo.web.ArchRepoApplication;
import ch.admin.bit.jeap.archrepo.web.rest.model.ModelStub;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

@SpringBootTest(classes={ArchRepoApplication.class}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"pact-provider-test"})
@Provider(value="${archrepo-service}")
@PactBroker
@IgnoreNoPactsToVerify
@AllowOverridePactUrl
public class PactProviderTestBase {
    @LocalServerPort
    private int localServerPort;
    @MockitoBean
    ArchitectureModelRepository architectureModelRepository;
    @MockitoBean
    OpenApiSpecRepository openApiSpecRepository;
    @MockitoBean
    SystemRepository systemRepository;
    @MockitoBean
    SystemComponentDatabaseSchemaRepository systemComponentDatabaseSchemaRepository;

    @BeforeEach
    void setUp(PactVerificationContext context) {
        if (context != null) {
            context.setTarget((TestTarget)new HttpTestTarget("localhost", this.localServerPort, "/"));
        }
    }

    @TestTemplate
    @ExtendWith(value={PactVerificationInvocationContextProvider.class})
    void testPacts(PactVerificationContext context) {
        if (context != null) {
            context.verifyInteraction();
        }
    }

    @State(value={"A model with one system and one service"})
    void simpleModel() {
        ArchitectureModel architectureModel = ModelStub.createSimpleModel();
        Mockito.when((Object)this.architectureModelRepository.load()).thenReturn((Object)architectureModel);
    }

    @State(value={"A model with one rest api relation"})
    void restApiRelations() {
        ArchitectureModel architectureModel = ModelStub.createSimpleModelWithOneRestApiRelation();
        Mockito.when((Object)this.architectureModelRepository.load()).thenReturn((Object)architectureModel);
    }

    @State(value={"A model with one component with an OpenAPI documentation"})
    void openApiDocumentationVersions() {
        Mockito.when((Object)this.openApiSpecRepository.getApiDocVersions()).thenReturn(List.of(new ApiDocVersionImpl("test-system", "test-component", "1.2.3")));
    }

    @State(value={"A database schema exists for the component 'test-component' in the system 'test-system'"})
    void databaseSchemaExists() {
        SystemComponent systemComponent = this.mockSystemAndComponent("test-system", "test-component");
        DatabaseSchema databaseSchema = this.getFullDatabaseSchema();
        SystemComponentDatabaseSchema systemComponentDatabaseSchema = SystemComponentDatabaseSchema.builder().systemComponent(systemComponent).schema(databaseSchema.toJson()).schemaVersion(databaseSchema.version()).build();
        Mockito.when((Object)this.systemComponentDatabaseSchemaRepository.findBySystemComponent(systemComponent)).thenReturn(Optional.of(systemComponentDatabaseSchema));
    }

    @State(value={"No database schema exists for the component 'test-component' in the system 'test-system'"})
    void noDatabaseSchemaExists() {
        SystemComponent systemComponent = this.mockSystemAndComponent("test-system", "test-component");
        Mockito.when((Object)this.systemComponentDatabaseSchemaRepository.findBySystemComponent(systemComponent)).thenReturn(Optional.empty());
    }

    private SystemComponent mockSystemAndComponent(String systemName, String systemComponentName) {
        System system = (System)Mockito.mock(System.class);
        Mockito.when((Object)system.getName()).thenReturn((Object)systemName);
        SystemComponent systemComponent = (SystemComponent)Mockito.mock(SystemComponent.class);
        Mockito.when((Object)systemComponent.getName()).thenReturn((Object)systemComponentName);
        Mockito.when((Object)systemComponent.getParent()).thenReturn((Object)system);
        Mockito.when((Object)system.findSystemComponent(systemComponentName)).thenReturn(Optional.of(systemComponent));
        Mockito.when((Object)this.systemRepository.findByNameContainingIgnoreCase(systemName)).thenReturn(Optional.of(system));
        return systemComponent;
    }

    private DatabaseSchema getFullDatabaseSchema() {
        Table tableA = Table.builder().name("table_a").columns(List.of(new TableColumn("column_a", "text", false))).primaryKey(new TablePrimaryKey("pk_a", List.of("column_a"))).build();
        Table tableB = Table.builder().name("table_b").columns(List.of(new TableColumn("column_b", "text", false))).columns(List.of(new TableColumn("column_c", "text", true))).foreignKeys(List.of(TableForeignKey.builder().name("fk_a_b").columnNames(List.of("column_b")).referencedColumnNames(List.of("column_a")).build())).build();
        return DatabaseSchema.builder().name("test-schema").version("1.2.3").tables(List.of(tableA, tableB)).build();
    }

    private static final class ApiDocVersionImpl
    implements ApiDocVersion {
        private final String system;
        private final String component;
        private final String version;

        @Generated
        public ApiDocVersionImpl(String system, String component, String version) {
            this.system = system;
            this.component = component;
            this.version = version;
        }

        @Generated
        public String getSystem() {
            return this.system;
        }

        @Generated
        public String getComponent() {
            return this.component;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApiDocVersionImpl)) {
                return false;
            }
            ApiDocVersionImpl other = (ApiDocVersionImpl)o;
            String this$system = this.getSystem();
            String other$system = other.getSystem();
            if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
                return false;
            }
            String this$component = this.getComponent();
            String other$component = other.getComponent();
            if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $system = this.getSystem();
            result = result * 59 + ($system == null ? 43 : $system.hashCode());
            String $component = this.getComponent();
            result = result * 59 + ($component == null ? 43 : $component.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PactProviderTestBase.ApiDocVersionImpl(system=" + this.getSystem() + ", component=" + this.getComponent() + ", version=" + this.getVersion() + ")";
        }
    }
}

