/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.messagetype.contractservice;

import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.junit5.PactConsumerTestExt;
import au.com.dius.pact.consumer.junit5.PactTestFor;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.annotations.Pact;
import ch.admin.bit.jeap.archrepo.importer.messagetype.MessageTypeImporterProperties;
import ch.admin.bit.jeap.archrepo.importer.messagetype.contractservice.ContractServiceClient;
import ch.admin.bit.jeap.archrepo.importer.messagetype.contractservice.MessageContractDto;
import ch.admin.bit.jeap.archrepo.importer.messagetype.contractservice.MessageContractRole;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.jgit.api.Git;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.web.client.RestClient;

@ExtendWith(value={PactConsumerTestExt.class})
@PactTestFor(port="8888", pactVersion=PactSpecVersion.V3)
public class MessageContractServicePactTestBase {
    private static final String API_PATH = "/api/contracts";
    private static String dummyGitRepoUrl;

    @BeforeAll
    static void beforeAll() throws Exception {
        File repoDir = new File("target/dummy-git-repo");
        FileUtils.copyDirectory((File)new File("src/test/resources/dummy-git-repo"), (File)repoDir);
        Git newRepo = Git.init().setDirectory(repoDir).call();
        newRepo.add().addFilepattern(".").call();
        newRepo.commit().setMessage("Initial revision").call();
        newRepo.close();
        dummyGitRepoUrl = "file://" + repoDir.getAbsolutePath();
    }

    @Pact(provider="${archrepo-messagecontract-provider}", consumer="${archrepo-service}")
    private RequestResponsePact requestContractsNonEmpty(PactDslWithProvider builder) {
        return builder.given("Contracts for the stage 'ref' are available.").uponReceiving("A GET request to /api/contracts").path(API_PATH).query("env=ref").method("GET").willRespondWith().status(200).matchHeader("Content-Type", "application/json", "application/json; encoding=utf-8").body(PactDslJsonArray.arrayEachLike().stringValue("appName", new String[]{"application-1"}).stringValue("messageType", new String[]{"InputDocArchivedEvent"}).stringValue("messageTypeVersion", new String[]{"2.0.0"}).stringValue("topic", new String[]{"given-topic"}).stringValue("role", new String[]{"CONSUMER"}).closeObject()).toPact();
    }

    @Test
    @PactTestFor(pactMethod="requestContractsNonEmpty")
    void testGetContracts() {
        MessageTypeImporterProperties properties = new MessageTypeImporterProperties(List.of(dummyGitRepoUrl), "http://localhost:8888/api/contracts");
        ContractServiceClient contractServiceClient = new ContractServiceClient(properties, RestClient.builder());
        List result = contractServiceClient.getMessageContracts("ref");
        Assertions.assertThat((List)result).isNotEmpty();
        MessageContractDto contract = (MessageContractDto)result.getFirst();
        Assertions.assertThat((String)contract.appName()).isEqualTo("application-1");
        Assertions.assertThat((String)contract.messageType()).isEqualTo("InputDocArchivedEvent");
        Assertions.assertThat((String)contract.messageTypeVersion()).isEqualTo("2.0.0");
        Assertions.assertThat((String)contract.topic()).isEqualTo("given-topic");
        Assertions.assertThat((Comparable)contract.role()).isIn(List.of(MessageContractRole.values()));
    }

    @Pact(provider="${archrepo-messagecontract-provider}", consumer="${archrepo-service}")
    private RequestResponsePact requestContractsEmptyList(PactDslWithProvider builder) {
        return builder.given("Contracts for the stage 'ref' are empty.").uponReceiving("A GET request to /api/contracts").path(API_PATH).query("env=ref").method("GET").willRespondWith().status(200).matchHeader("Content-Type", "application/json", "application/json; encoding=utf-8").body(PactDslJsonArray.arrayEachLike((int)0).closeObject()).toPact();
    }

    @Test
    @PactTestFor(pactMethod="requestContractsEmptyList")
    void testGetEmptyList() {
        MessageTypeImporterProperties properties = new MessageTypeImporterProperties(List.of(dummyGitRepoUrl), "http://localhost:8888/api/contracts");
        ContractServiceClient contractServiceClient = new ContractServiceClient(properties, RestClient.builder());
        List result = contractServiceClient.getMessageContracts("ref");
        ((ListAssert)Assertions.assertThat((List)result).isNotNull()).isEmpty();
    }
}

