/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.importer.reaction;

import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslJsonArray;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.junit5.PactConsumerTestExt;
import au.com.dius.pact.consumer.junit5.PactTestFor;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.annotations.Pact;
import ch.admin.bit.jeap.archrepo.importer.reaction.ReactionObserverServiceProperties;
import ch.admin.bit.jeap.archrepo.importer.reaction.ReactionsObserverImporterConfiguration;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.ActionDto;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.GraphDto;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.MessageGraphDto;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.ReactionObserverService;
import ch.admin.bit.jeap.archrepo.importer.reaction.client.ReactionsObservedStatisticsDto;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={PactConsumerTestExt.class})
@PactTestFor(port="8888", pactVersion=PactSpecVersion.V3)
public class ReactionObserverServicePactTestBase {
    private static final String BASE_API_PATH = "/api";
    private static final String STATISTICS_API_PATH = "/api/statistics";
    private static final String GRAPHS_API_PATH = "/api/graphs";
    private ObjectMapper objectMapper = new ObjectMapper();

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getStatisticsForKnownComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("Statistics for component 'c1' are available").uponReceiving("A GET request to /api/statistics/c1").path("/api/statistics/c1").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body("[\n  {\n    \"component\": \"c1\",\n    \"triggerType\": \"command\",\n    \"triggerFqn\": \"SomeCommand\",\n    \"actions\": [\n      {\n        \"actionType\": \"event\",\n        \"actionFqn\": \"SomeEvent\",\n        \"actionProperties\": {}\n      }\n    ],\n    \"count\": 100,\n    \"median\": 50.0,\n    \"percentage\": 75.0,\n    \"triggerProperties\": {}\n  }\n]\n").toPact();
    }

    @Test
    @PactTestFor(pactMethod="getStatisticsForKnownComponentInteraction")
    void testGetStatistics() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        List result = reactionObserverService.getReactionsObservedStatistics("c1");
        Assertions.assertThat((List)result).isNotEmpty();
        ReactionsObservedStatisticsDto statisticsDto = (ReactionsObservedStatisticsDto)result.getFirst();
        Assertions.assertThat((String)statisticsDto.component()).isEqualTo("c1");
        Assertions.assertThat((String)statisticsDto.triggerType()).isEqualTo("command");
        Assertions.assertThat((String)statisticsDto.triggerFqn()).isEqualTo("SomeCommand");
        Assertions.assertThat((List)statisticsDto.actions()).isNotEmpty();
        ActionDto action = (ActionDto)statisticsDto.actions().getFirst();
        Assertions.assertThat((String)action.actionType()).isEqualTo("event");
        Assertions.assertThat((String)action.actionFqn()).isEqualTo("SomeEvent");
        Assertions.assertThat((long)statisticsDto.count()).isGreaterThan(0L);
        Assertions.assertThat((double)statisticsDto.median()).isGreaterThan(0.0);
        Assertions.assertThat((Double)statisticsDto.percentage()).isGreaterThan(0.0);
    }

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getStatisticsForUnknownComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("Statistics for unknown component are empty").uponReceiving("A GET request to /api/statistics/unknown").path("/api/statistics/unknown").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body((DslPart)PactDslJsonArray.newUnorderedArray()).toPact();
    }

    @Test
    @PactTestFor(pactMethod="getStatisticsForUnknownComponentInteraction")
    void testGetStatisticsUnknownComponent() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        List result = reactionObserverService.getReactionsObservedStatistics("unknown");
        Assertions.assertThat((List)result).isEmpty();
    }

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getSystemNamesComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("System names are available").uponReceiving("A GET request to /api/systems/names").path("/api/systems/names").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body("[\n  \"system-1\",\n  \"system-2\"\n]\n").toPact();
    }

    @Test
    @PactTestFor(pactMethod="getSystemNamesComponentInteraction")
    void testGetSystemNames() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        List systemNames = reactionObserverService.getSystemNames();
        Assertions.assertThat((List)systemNames).isNotEmpty();
        Assertions.assertThat((String)((String)systemNames.getFirst())).isEqualTo("system-1");
        Assertions.assertThat((String)((String)systemNames.getLast())).isEqualTo("system-2");
    }

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getSystemGraphComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("System graphs are available").uponReceiving("A GET request to /api/graphs/systems/sys1").path("/api/graphs/systems/sys1").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body("        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"nodeType\": \"MESSAGE\",\n                \"id\": 2,\n                \"messageType\": \"Command2\",\n                \"variant\": null\n              },\n              {\n                \"nodeType\": \"REACTION\",\n                \"id\": 1,\n                \"component\": \"service1\"\n              }\n            ],\n            \"edges\": [\n              {\n                \"edgeType\": \"TRIGGER\",\n                \"sourceId\": 2,\n                \"sourceNodeType\": \"MESSAGE\",\n                \"targetReactionId\": 1,\n                \"median\": 5\n              }\n            ]\n          },\n          \"fingerprint\": \"d2a3e71875d3419799fd68958990ee058d589becb764607a286d65896ce74de3\"\n        }\n").toPact();
    }

    @Test
    @PactTestFor(pactMethod="getSystemGraphComponentInteraction")
    void testGetSystemGraph() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        GraphDto graph = reactionObserverService.getSystemGraph("sys1");
        Assertions.assertThat((Object)graph).isNotNull();
        Assertions.assertThat((String)graph.fingerprint()).isEqualTo("d2a3e71875d3419799fd68958990ee058d589becb764607a286d65896ce74de3");
        try {
            String jsonValue = this.objectMapper.writeValueAsString(graph.graph());
            Assertions.assertThat((String)jsonValue).isNotEmpty();
            Assertions.assertThat((List)((List)JsonPath.read((String)jsonValue, (String)"$.nodes", (Predicate[])new Predicate[0]))).hasSize(2);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.nodes[0].nodeType", (Predicate[])new Predicate[0]))).isEqualTo("MESSAGE");
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.nodes[0].id", (Predicate[])new Predicate[0]))).isEqualTo(2);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.nodes[0].messageType", (Predicate[])new Predicate[0]))).isEqualTo("Command2");
            Assertions.assertThat((List)((List)JsonPath.read((String)jsonValue, (String)"$.edges", (Predicate[])new Predicate[0]))).hasSize(1);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.edges[0].edgeType", (Predicate[])new Predicate[0]))).isEqualTo("TRIGGER");
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.edges[0].sourceId", (Predicate[])new Predicate[0]))).isEqualTo(2);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.edges[0].sourceNodeType", (Predicate[])new Predicate[0]))).isEqualTo("MESSAGE");
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.edges[0].targetReactionId", (Predicate[])new Predicate[0]))).isEqualTo(1);
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.edges[0].median", (Predicate[])new Predicate[0]))).isEqualTo(5);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getComponentGraphComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("Component graphs are available").uponReceiving("A GET request to /api/graphs/components/service1").path("/api/graphs/components/service1").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body("        {\n          \"graph\": {\n            \"nodes\": [\n              {\n                \"nodeType\": \"MESSAGE\",\n                \"id\": 2,\n                \"messageType\": \"Command2\",\n                \"variant\": null\n              },\n              {\n                \"nodeType\": \"REACTION\",\n                \"id\": 1,\n                \"component\": \"service1\"\n              }\n            ],\n            \"edges\": [\n              {\n                \"edgeType\": \"TRIGGER\",\n                \"sourceId\": 2,\n                \"sourceNodeType\": \"MESSAGE\",\n                \"targetReactionId\": 1,\n                \"median\": 5\n              }\n            ]\n          },\n          \"fingerprint\": \"d2a3e71875d3419799fd68958990ee058d589becb764607a286d65896ce74de3\"\n        }\n").toPact();
    }

    @Test
    @PactTestFor(pactMethod="getComponentGraphComponentInteraction")
    void testGetComponentGraph() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        GraphDto graph = reactionObserverService.getComponentGraph("service1");
        Assertions.assertThat((Object)graph).isNotNull();
        Assertions.assertThat((String)graph.fingerprint()).isEqualTo("d2a3e71875d3419799fd68958990ee058d589becb764607a286d65896ce74de3");
        try {
            String jsonValue = this.objectMapper.writeValueAsString(graph.graph());
            Assertions.assertThat((String)jsonValue).isNotEmpty();
            Assertions.assertThat((List)((List)JsonPath.read((String)jsonValue, (String)"$.nodes", (Predicate[])new Predicate[0]))).hasSize(2);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.nodes[0].nodeType", (Predicate[])new Predicate[0]))).isEqualTo("MESSAGE");
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.nodes[0].id", (Predicate[])new Predicate[0]))).isEqualTo(2);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.nodes[0].messageType", (Predicate[])new Predicate[0]))).isEqualTo("Command2");
            Assertions.assertThat((List)((List)JsonPath.read((String)jsonValue, (String)"$.edges", (Predicate[])new Predicate[0]))).hasSize(1);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.edges[0].edgeType", (Predicate[])new Predicate[0]))).isEqualTo("TRIGGER");
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.edges[0].sourceId", (Predicate[])new Predicate[0]))).isEqualTo(2);
            Assertions.assertThat((String)((String)JsonPath.read((String)jsonValue, (String)"$.edges[0].sourceNodeType", (Predicate[])new Predicate[0]))).isEqualTo("MESSAGE");
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.edges[0].targetReactionId", (Predicate[])new Predicate[0]))).isEqualTo(1);
            Assertions.assertThat((Integer)((Integer)JsonPath.read((String)jsonValue, (String)"$.edges[0].median", (Predicate[])new Predicate[0]))).isEqualTo(5);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Pact(provider="${archrepo-reactionobserverservice-provider}", consumer="${archrepo-service}")
    private RequestResponsePact getMessageGraphComponentInteraction(PactDslWithProvider builder) {
        String basicAuth = Base64.getEncoder().encodeToString("user:secret".getBytes());
        return builder.given("Message graphs are available").uponReceiving("A GET request to /api/graphs/messages/ExistingEvent").path("/api/graphs/messages/ExistingEvent").method("GET").matchHeader("Authorization", "Basic " + basicAuth, "Basic " + basicAuth).willRespondWith().status(200).matchHeader("Content-Type", "application/json").body("        {\n          \"ExistingEvent/default\": {\n            \"graph\": {\n              \"nodes\": [\n                {\n                  \"nodeType\": \"MESSAGE\",\n                  \"id\": 123,\n                  \"messageType\": \"ExistingEvent\",\n                  \"variant\": \"default\"\n                },\n                {\n                  \"nodeType\": \"REACTION\",\n                  \"id\": 77,\n                  \"component\": \"notification-service\"\n                }\n              ],\n              \"edges\": [\n                {\n                  \"edgeType\": \"TRIGGER\",\n                  \"sourceId\": 123,\n                  \"sourceNodeType\": \"MESSAGE\",\n                  \"targetReactionId\": 77,\n                  \"median\": 10\n                },\n                {\n                  \"edgeType\": \"ACTION\",\n                  \"sourceReactionId\": 77,\n                  \"targetId\": 123,\n                  \"targetNodeType\": \"MESSAGE\"\n                }\n              ]\n            },\n            \"fingerprint\": \"updated-fingerprint\"\n          }\n        }\n").toPact();
    }

    @Test
    @PactTestFor(pactMethod="getMessageGraphComponentInteraction")
    void testGetMessageGraph() {
        ReactionObserverServiceProperties props = new ReactionObserverServiceProperties();
        props.setUrl("http://localhost:8888");
        props.setUsername("user");
        props.setPassword("secret");
        ReactionObserverService reactionObserverService = new ReactionsObserverImporterConfiguration().reactionObserverService(props);
        MessageGraphDto messageGraph = reactionObserverService.getMessageGraph("ExistingEvent");
        Assertions.assertThat((Map)messageGraph).isNotNull();
        Assertions.assertThat((Collection)messageGraph.getVariants()).contains((Object[])new String[]{"ExistingEvent/default"});
        GraphDto graph = (GraphDto)messageGraph.get((Object)"ExistingEvent/default");
        Assertions.assertThat((Object)graph).isNotNull();
        Assertions.assertThat((String)graph.fingerprint()).isEqualTo("updated-fingerprint");
        try {
            String jsonValue = this.objectMapper.writeValueAsString(graph.graph());
            Assertions.assertThat((String)jsonValue).isNotEmpty();
            Assertions.assertThat((List)((List)JsonPath.read((String)jsonValue, (String)"$.nodes", (Predicate[])new Predicate[0]))).hasSize(2);
            List messageNodes = (List)JsonPath.read((String)jsonValue, (String)"$.nodes[?(@.nodeType == 'MESSAGE' && @.id == 123)]", (Predicate[])new Predicate[0]);
            Assertions.assertThat((List)messageNodes).hasSize(1);
            Assertions.assertThat(((Map)messageNodes.getFirst()).get("variant")).isEqualTo((Object)"default");
            Assertions.assertThat(((Map)messageNodes.getFirst()).get("messageType")).isEqualTo((Object)"ExistingEvent");
            List reactionNodes = (List)JsonPath.read((String)jsonValue, (String)"$.nodes[?(@.nodeType == 'REACTION' && @.component == 'notification-service')]", (Predicate[])new Predicate[0]);
            Assertions.assertThat((List)reactionNodes).hasSize(1);
            Assertions.assertThat((List)((List)JsonPath.read((String)jsonValue, (String)"$.edges", (Predicate[])new Predicate[0]))).hasSize(2);
            List triggerEdges = (List)JsonPath.read((String)jsonValue, (String)"$.edges[?(@.edgeType == 'TRIGGER' && @.sourceId == 123 && @.targetReactionId == 77)]", (Predicate[])new Predicate[0]);
            Assertions.assertThat((List)triggerEdges).hasSize(1);
            Assertions.assertThat(((Map)triggerEdges.getFirst()).get("sourceNodeType")).isEqualTo((Object)"MESSAGE");
            Assertions.assertThat(((Map)triggerEdges.getFirst()).get("median")).isEqualTo((Object)10);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

