/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.model;

import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.Relation;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.relation.CommandRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.EventRelation;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.web.rest.model.ModelDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.RelationDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.RestApiRelationDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.SystemComponentDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.SystemDto;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@Component
class ModelDtoFactory {
    ModelDtoFactory() {
    }

    ModelDto createModelDto(ArchitectureModel model) {
        return ModelDto.builder().systems(ModelDtoFactory.map(model.getSystems(), this::createSystemDto)).build();
    }

    private SystemDto createSystemDto(System system) {
        return SystemDto.builder().aliases(Set.copyOf(system.getAliases())).name(system.getName()).ownedBy(system.getDefaultOwner() != null ? system.getDefaultOwner().getName() : null).description(system.getDescription()).systemComponents(ModelDtoFactory.map(system.getSystemComponents(), this::createSystemComponentDto)).build();
    }

    private SystemComponentDto createSystemComponentDto(SystemComponent component) {
        return SystemComponentDto.builder().type(component.getType()).name(component.getName()).importer(component.getImporter()).ownedBy(component.getOwnedBy() == null ? null : component.getOwnedBy().getName()).description(component.getDescription()).build();
    }

    private static <E, R> List<R> map(List<E> elements, Function<E, R> mapper) {
        return elements.stream().map(mapper).toList();
    }

    public List<RelationDto> createRelationDtos(ArchitectureModel model, System system) {
        Map servicesAndSystems = model.getAllSystemComponentNamesWithSystemName();
        return model.getSystems().stream().flatMap(s -> s.getActiveRelations().stream()).filter(r -> this.consumerOrProducerIsForSystem((Relation)r, system.getName(), servicesAndSystems)).map(r -> this.createRelationDto(servicesAndSystems, (Relation)r)).toList();
    }

    private boolean consumerOrProducerIsForSystem(Relation relation, String system, Map<String, String> servicesAndSystems) {
        return system.equalsIgnoreCase(servicesAndSystems.get(relation.getConsumerName())) || system.equalsIgnoreCase(servicesAndSystems.get(relation.getProviderName()));
    }

    RelationDto createRelationDto(Map<String, String> componentNameToSystemName, Relation relation) {
        RelationDto.RelationDtoBuilder builder = RelationDto.builder().relationType(relation.getType()).consumerSystem(componentNameToSystemName.get(relation.getConsumerName())).consumer(relation.getConsumerName()).providerSystem(componentNameToSystemName.get(relation.getProviderName())).provider(relation.getProviderName());
        Relation relation2 = relation;
        Objects.requireNonNull(relation2);
        Relation relation3 = relation2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RestApiRelation.class, EventRelation.class, CommandRelation.class}, (Object)relation3, n)) {
            case 0: {
                RestApiRelation restApiRelation = (RestApiRelation)relation3;
                builder.method(restApiRelation.getRestApi().getMethod()).path(restApiRelation.getRestApi().getPath());
                break;
            }
            case 1: {
                EventRelation eventRelation = (EventRelation)relation3;
                builder.messageType(eventRelation.getEventName());
                break;
            }
            case 2: {
                CommandRelation commandRelation = (CommandRelation)relation3;
                builder.messageType(commandRelation.getCommandName());
                break;
            }
        }
        return builder.build();
    }

    RestApiRelationDto createRestApiRelationDto(Map<String, String> componentNameToSystemName, RestApiRelation relation) {
        return RestApiRelationDto.builder().consumerSystem(componentNameToSystemName.get(relation.getConsumerName())).consumer(relation.getConsumerName()).providerSystem(componentNameToSystemName.get(relation.getProviderName())).provider(relation.getProviderName()).method(relation.getRestApi().getMethod()).path(relation.getRestApi().getPath()).build();
    }
}

