/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.service;

import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.Team;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponentFactory;
import ch.admin.bit.jeap.archrepo.persistence.SystemComponentRepository;
import ch.admin.bit.jeap.archrepo.persistence.SystemRepository;
import ch.admin.bit.jeap.archrepo.persistence.TeamRepository;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SystemComponentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SystemComponentService.class);
    private final TeamRepository teamRepository;
    private final SystemRepository systemRepository;
    private final SystemComponentRepository systemComponentRepository;

    @Transactional
    public SystemComponent findOrCreateSystemComponent(String componentName) {
        log.info("Retrieve system component: {}", (Object)componentName);
        return this.systemComponentRepository.findByNameIgnoreCase(componentName).orElseGet(() -> this.createSystemComponent(componentName));
    }

    private SystemComponent createSystemComponent(String componentName) {
        System system = this.findOrCreateSystem(this.extractSystemName(componentName));
        SystemComponent systemComponent = SystemComponentFactory.createSystemComponent((System)system, (String)componentName, (Importer)Importer.REST_CONTROLLER);
        log.info("Created system component: {} in system: {}", (Object)systemComponent.getName(), (Object)system.getName());
        return systemComponent;
    }

    private String extractSystemName(String componentName) {
        return componentName.split("-")[0];
    }

    private System findOrCreateSystem(String systemName) {
        return this.systemRepository.findByNameIgnoreCase(systemName).or(() -> this.findSystemAliases(systemName)).orElseGet(() -> this.createSystem(systemName));
    }

    private System createSystem(String systemName) {
        log.info("Creating system and team: {}", (Object)systemName);
        return (System)this.systemRepository.save((Object)System.builder().name(systemName).defaultOwner((Team)this.teamRepository.save((Object)Team.builder().name(systemName).build())).build());
    }

    public Optional<System> findSystemAliases(String systemName) {
        return this.systemRepository.findAll().stream().filter(system -> this.matchesSystemNameOrAlias(systemName, (System)system)).findFirst();
    }

    private boolean matchesSystemNameOrAlias(String systemName, System system) {
        return systemName.equalsIgnoreCase(system.getName()) || system.getAliases() != null && system.getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(systemName));
    }

    @Generated
    public SystemComponentService(TeamRepository teamRepository, SystemRepository systemRepository, SystemComponentRepository systemComponentRepository) {
        this.teamRepository = teamRepository;
        this.systemRepository = systemRepository;
        this.systemComponentRepository = systemComponentRepository;
    }
}

