/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
public class WebSecurityConfig {
    @Value(value="${archrepo.api.secret}")
    private String apiSecret;

    @Bean
    @Order(value=100)
    SecurityFilterChain apiSecurityFilterChain(HttpSecurity http) throws Exception {
        AndRequestMatcher apiExceptDatabaseSchema = new AndRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/api/**"), new NegatedRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/api/dbschemas/**"))});
        http.securityMatcher((RequestMatcher)apiExceptDatabaseSchema);
        http.authorizeHttpRequests(r -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)r.requestMatchers(HttpMethod.GET, new String[]{"/api/model"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/model/*/relations"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/model/rest-api-relation-without-pact"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/model/system-components-without-open-api-spec"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/openapi/**"})).permitAll().anyRequest()).hasRole("api"));
        http.csrf(AbstractHttpConfigurer::disable);
        http.httpBasic(Customizer.withDefaults());
        http.authenticationManager(this.createApiAuthManager((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)));
        return (SecurityFilterChain)http.build();
    }

    private AuthenticationManager createApiAuthManager(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser("api").password(this.apiSecret).roles(new String[]{"api"});
        return (AuthenticationManager)auth.build();
    }
}

