/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.database;

import ch.admin.bit.jeap.archrepo.web.rest.database.CreateOrUpdateDbSchemaDto;
import lombok.Generated;
import org.springframework.http.HttpStatus;

public class DatabaseSchemaException
extends RuntimeException {
    private final HttpStatus responseStatus;

    private DatabaseSchemaException(String message, HttpStatus responseStatus) {
        super(message);
        this.responseStatus = responseStatus;
    }

    private DatabaseSchemaException(String message, HttpStatus responseStatus, Exception e) {
        super(message, e);
        this.responseStatus = responseStatus;
    }

    static DatabaseSchemaException unexpectedError(CreateOrUpdateDbSchemaDto schemaDto, String message) {
        return new DatabaseSchemaException(DatabaseSchemaException.unexpectedErrorMessage(schemaDto, message), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    static DatabaseSchemaException unexpectedError(CreateOrUpdateDbSchemaDto schemaDto, Exception e) {
        return new DatabaseSchemaException(DatabaseSchemaException.unexpectedErrorMessage(schemaDto, e.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR, e);
    }

    static DatabaseSchemaException unexpectedError(String systemComponent, Exception e) {
        return new DatabaseSchemaException(DatabaseSchemaException.unexpectedErrorMessage(systemComponent, e.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR, e);
    }

    static DatabaseSchemaException schemaSerializationError(CreateOrUpdateDbSchemaDto schemaDto, Exception e) {
        String message = "Unable to serialize the database schema for the component '%s': %s".formatted(schemaDto.getSystemComponentName(), e.getMessage());
        return new DatabaseSchemaException(message, HttpStatus.INTERNAL_SERVER_ERROR, e);
    }

    static DatabaseSchemaException schemaDeserializationError(String system, String systemComponent, Exception e) {
        String message = "Unable to deserialize the database schema for the component '%s' and the system '%s': %s".formatted(systemComponent, system, e.getMessage());
        return new DatabaseSchemaException(message, HttpStatus.INTERNAL_SERVER_ERROR, e);
    }

    private static String unexpectedErrorMessage(CreateOrUpdateDbSchemaDto schemaDto, String message) {
        return DatabaseSchemaException.unexpectedErrorMessage(schemaDto.getSystemComponentName(), message);
    }

    private static String unexpectedErrorMessage(String systemComponent, String message) {
        return "An unexpected error happened while processing the database schema for the component '%s': %s.".formatted(systemComponent, message);
    }

    @Generated
    public HttpStatus getResponseStatus() {
        return this.responseStatus;
    }
}

