/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.job;

import ch.admin.bit.jeap.archrepo.web.rest.job.JobDto;
import ch.admin.bit.jeap.archrepo.web.service.UpdateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/jobs"})
@Tag(name="jobs", description="Architecture repository jobs")
public class JobsController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobsController.class);
    private final UpdateService updateService;

    @PostMapping
    @Operation(summary="Create a new job", description="Create a new job to trigger Documentation Generation, Documentation Deletion (do not use on prod space!) oder Model Update manually")
    @ApiResponse(responseCode="200", description="Job successfully created and started asynchronously")
    @Async
    public void triggerUpdate(@RequestBody JobDto jobDto) {
        switch (jobDto.getType()) {
            case GENERATE_DOC: {
                this.updateService.generateDocumentation();
                break;
            }
            case UPDATE_MODEL: {
                this.updateService.updateModel();
            }
        }
    }

    @PostMapping(value={"/import/{importerName}"})
    @Operation(summary="Run a specific import job")
    @ApiResponse(responseCode="200", description="Job successfully created and started asynchronously")
    @Async
    public void runImporter(@PathVariable String importerName) {
        this.updateService.runImporter(importerName);
    }

    @ConstructorProperties(value={"updateService"})
    @Generated
    public JobsController(UpdateService updateService) {
        this.updateService = updateService;
    }
}

