/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.openapi;

import ch.admin.bit.jeap.archrepo.importer.openapi.OpenApiImporter;
import ch.admin.bit.jeap.archrepo.metamodel.Importer;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.restapi.OpenApiSpec;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.persistence.ApiDocDto;
import ch.admin.bit.jeap.archrepo.persistence.ApiDocVersion;
import ch.admin.bit.jeap.archrepo.persistence.OpenApiSpecRepository;
import ch.admin.bit.jeap.archrepo.persistence.RestApiRepository;
import ch.admin.bit.jeap.archrepo.persistence.SystemComponentRepository;
import ch.admin.bit.jeap.archrepo.web.rest.model.RestApiDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.RestApiResultDto;
import ch.admin.bit.jeap.archrepo.web.rest.openapi.OpenApiException;
import ch.admin.bit.jeap.archrepo.web.service.SystemComponentService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.Size;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/openapi"})
@Tag(name="openapi", description="OpenAPI Repository")
class OpenApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiController.class);
    private static final int SYSTEM_MAX_LENGTH = 200;
    private static final int COMPONENT_MAX_LENGTH = 200;
    private static final int VERSION_MAX_LENGTH = 200;
    @Value(value="${archrepo.openapi-base-url}")
    private String openApiBaseUrl;
    private final SystemComponentRepository systemComponentRepository;
    private final OpenApiSpecRepository openApiSpecRepository;
    private final RestApiRepository restApiRepository;
    private final OpenApiImporter openApiImporter;
    private final SystemComponentService systemComponentService;

    @Transactional
    @PostMapping(value={"/{systemName}/{systemComponentName}"}, consumes={"multipart/form-data"})
    @Operation(summary="Upload an OpenApi Spec", requestBody=@RequestBody(content={@Content(mediaType="multipart/form-data")}))
    public ResponseEntity<String> handleFileUploadWithSystemName(@PathVariable(value="systemName") @Size(max=200) @Size(max=200) String ignored, @PathVariable(value="systemComponentName") @Size(max=200) @Size(max=200) String systemComponentName, @RequestParam(name="version", required=false) @Size(max=200) @Size(max=200) String version, @RequestParam(name="file") MultipartFile file) throws IOException {
        return this.handleFileUpload(systemComponentName, version, file);
    }

    @Transactional
    @PostMapping(value={"/{systemComponentName}"}, consumes={"multipart/form-data"})
    @Operation(summary="Upload an OpenApi Spec", requestBody=@RequestBody(content={@Content(mediaType="multipart/form-data")}))
    public ResponseEntity<String> handleFileUpload(@PathVariable(value="systemComponentName") @Size(max=200) @Size(max=200) String systemComponentName, @RequestParam(name="version", required=false) @Size(max=200) @Size(max=200) String version, @RequestParam(name="file") MultipartFile file) throws IOException {
        try {
            SystemComponent systemComponent = this.systemComponentService.findOrCreateSystemComponent(systemComponentName);
            System system = systemComponent.getParent();
            Optional openApiSpecOptional = this.openApiSpecRepository.findByProvider(systemComponent);
            String serverUrl = this.openApiImporter.getServerUrl(file.getBytes());
            if (openApiSpecOptional.isEmpty()) {
                OpenApiSpec openApiSpec = OpenApiSpec.builder().provider(systemComponent).version(version).content(file.getBytes()).serverUrl(serverUrl).build();
                log.info("Save new openApiSpec for system {} and systemComponent {} as {}", new Object[]{system.getName(), systemComponent.getName(), openApiSpec});
                this.openApiSpecRepository.save((Object)openApiSpec);
            } else {
                OpenApiSpec openApiSpec = (OpenApiSpec)openApiSpecOptional.get();
                openApiSpec.update(file.getBytes(), version, serverUrl);
                log.info("Update openApiSpec for system {} and systemComponent {} with new content as {}", new Object[]{system.getName(), systemComponent.getName(), openApiSpec});
            }
            this.openApiImporter.importIntoModel(systemComponent, file.getBytes());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        catch (OpenApiException openApiException) {
            log.warn("Error in OpenApi upload: {}", (Object)openApiException.getMessage());
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "OpenApi upload failed", (Throwable)openApiException);
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{systemName}/{systemComponentName}"})
    @Operation(summary="Get the OpenApi Spec of a systemComponent")
    public String getOpenApiJsonWithSystemName(@PathVariable(value="systemName") @Size(max=200) @Size(max=200) String ignored, @PathVariable(value="systemComponentName") @Size(max=200) @Size(max=200) String systemComponentName) {
        return this.getOpenApiJson(systemComponentName);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{systemComponentName}"})
    @Operation(summary="Get the OpenApi Spec of a systemComponent")
    public String getOpenApiJson(@PathVariable(value="systemComponentName") @Size(max=200) @Size(max=200) String systemComponentName) {
        log.info("Retrieve openApiSpec for systemComponent {}", (Object)systemComponentName);
        SystemComponent systemComponent = (SystemComponent)this.systemComponentRepository.findByNameIgnoreCase(systemComponentName).orElseThrow(() -> OpenApiException.systemComponentNotExists(systemComponentName));
        Optional openApiSpecOptional = this.openApiSpecRepository.findByProvider(systemComponent);
        if (openApiSpecOptional.isEmpty()) {
            throw new IllegalStateException("No Open API spec found for system component " + systemComponentName);
        }
        log.debug("Found openApiSpec {} ", openApiSpecOptional.get());
        return new String(((OpenApiSpec)openApiSpecOptional.get()).getContent(), StandardCharsets.UTF_8);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/versions"}, produces={"application/json"})
    @Operation(summary="Get the API documentation versions of all system components.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The API documentation versions of all system components.", content={@Content(mediaType="application/json")})})
    public List<ApiDocVersion> getApiDocVersions() {
        log.debug("Retrieving API documentation versions.");
        List apiDocVersions = this.openApiSpecRepository.getApiDocVersions();
        log.debug("Returning API documentation versions for '{}' system components", (Object)apiDocVersions.size());
        return apiDocVersions;
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{systemName}/{systemComponentName}/rest-apis"})
    @Operation(summary="All rest apis imported from open api spec", description="Get all rest apis imported from open api spec for a certain system and component. Use /api/model to discover available systems and components.")
    public ResponseEntity<RestApiResultDto> getRestApiForServiceWithSystemName(@PathVariable(value="systemName") @Size(max=200) @Size(max=200) String ignored, @PathVariable(value="systemComponentName") @Size(max=200) @Size(max=200) String systemComponentName) {
        return this.getRestApiForService(systemComponentName);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/{systemComponentName}/rest-apis"})
    @Operation(summary="All rest apis imported from open api spec", description="Get all rest apis imported from open api spec for a certain system component. Use /api/model to discover available systems and components.")
    public ResponseEntity<RestApiResultDto> getRestApiForService(@PathVariable(value="systemComponentName") @Size(max=200) @Size(max=200) String systemComponentName) {
        log.info("Retrieve rest apis for system component {}", (Object)systemComponentName);
        SystemComponent systemComponent = (SystemComponent)this.systemComponentRepository.findByNameIgnoreCase(systemComponentName).orElseThrow(() -> OpenApiException.systemComponentNotExists(systemComponentName));
        Optional apiDocVersion = this.openApiSpecRepository.getApiDocVersion(systemComponent);
        if (apiDocVersion.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        List<RestApiDto> restApis = this.restApiRepository.findByProvider(systemComponent).stream().filter(r -> r.getImporters().contains(Importer.OPEN_API)).map(r -> new RestApiDto(r.getMethod(), r.getPath())).toList();
        log.info("Found {} rest apis with OPEN_API importer", (Object)restApis.size());
        return ResponseEntity.ok((Object)RestApiResultDto.of((ApiDocDto)apiDocVersion.get(), restApis));
    }

    @PostConstruct
    void setupOpenApiBaseUrl() {
        if (this.openApiBaseUrl == null || this.openApiBaseUrl.isEmpty()) {
            throw OpenApiException.openApiBaseUrlIsNotSet();
        }
    }

    @ConstructorProperties(value={"systemComponentRepository", "openApiSpecRepository", "restApiRepository", "openApiImporter", "systemComponentService"})
    @Generated
    public OpenApiController(SystemComponentRepository systemComponentRepository, OpenApiSpecRepository openApiSpecRepository, RestApiRepository restApiRepository, OpenApiImporter openApiImporter, SystemComponentService systemComponentService) {
        this.systemComponentRepository = systemComponentRepository;
        this.openApiSpecRepository = openApiSpecRepository;
        this.restApiRepository = restApiRepository;
        this.openApiImporter = openApiImporter;
        this.systemComponentService = systemComponentService;
    }
}

