/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.model;

import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.persistence.ArchitectureModelRepository;
import ch.admin.bit.jeap.archrepo.web.rest.model.ModelDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.ModelDtoFactory;
import ch.admin.bit.jeap.archrepo.web.rest.model.RelationDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.RestApiRelationDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/model"})
@Tag(name="model", description="Architecture meta model")
@Transactional(readOnly=true)
class ModelController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelController.class);
    private final ArchitectureModelRepository repository;
    private final ModelDtoFactory dtoFactory;
    private final ModelDtoFactory modelDtoFactory;

    @GetMapping
    @Operation(summary="Structural architecture model without relations", description="Get a list of all systems and components")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", schema=@Schema(implementation=ModelDto.class), examples={@ExampleObject(name="relations", ref="#/components/examples/modelExample")})})})
    public ModelDto getModel() {
        ArchitectureModel model = this.repository.load();
        return this.dtoFactory.createModelDto(model);
    }

    @GetMapping(value={"/rest-api-relation-without-pact"})
    @Operation(summary="Represents REST relations with missing Pact tests", description="Get all REST API relations for which no Pact test was found")
    public List<RestApiRelationDto> getAllRestApiRelationsWithoutPact() {
        ArchitectureModel model = this.repository.load();
        Map servicesAndSystems = model.getAllSystemComponentNamesWithSystemName();
        return model.getRestApiRelationsWithoutPact().stream().map(relation -> this.modelDtoFactory.createRestApiRelationDto(servicesAndSystems, (RestApiRelation)relation)).toList();
    }

    @GetMapping(value={"/system-components-without-open-api-spec"})
    @Operation(summary="Represents System Components without open api spec", description="Get all System Components for which open api spec was defined")
    public List<String> getSystemComponentsWithoutOpenApiSpec() {
        ArchitectureModel model = this.repository.load();
        return model.getSystemComponentsWithoutOpenApiSpec();
    }

    @GetMapping(value={"/{system}/relations"})
    @Operation(summary="All relations (REST, messaging, ...)", description="Get all relations (REST, messaging, ...) for a certain system. Use /api/model to discover available systems and components.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful response", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RelationDto.class)), examples={@ExampleObject(name="relations", ref="#/components/examples/relationsExample")})}), @ApiResponse(responseCode="404", description="No system with this name exists", content={@Content(mediaType="application/json")})})
    public List<RelationDto> getAllRelations(@PathVariable(value="system") String systemName) {
        ArchitectureModel model = this.repository.load();
        System system = model.getSystems().stream().filter(s -> s.getName().equalsIgnoreCase(systemName)).findFirst().orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "System not found"));
        return this.dtoFactory.createRelationDtos(model, system);
    }

    @ConstructorProperties(value={"repository", "dtoFactory", "modelDtoFactory"})
    @Generated
    public ModelController(ArchitectureModelRepository repository, ModelDtoFactory dtoFactory, ModelDtoFactory modelDtoFactory) {
        this.repository = repository;
        this.dtoFactory = dtoFactory;
        this.modelDtoFactory = modelDtoFactory;
    }
}

