/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.admin;

import ch.admin.bit.jeap.archrepo.metamodel.System;
import ch.admin.bit.jeap.archrepo.metamodel.Team;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RelationStatus;
import ch.admin.bit.jeap.archrepo.metamodel.relation.RestApiRelation;
import ch.admin.bit.jeap.archrepo.persistence.RestApiRelationRepository;
import ch.admin.bit.jeap.archrepo.persistence.SystemRepository;
import ch.admin.bit.jeap.archrepo.persistence.TeamRepository;
import ch.admin.bit.jeap.archrepo.web.rest.model.CreateSystemDto;
import ch.admin.bit.jeap.archrepo.web.rest.model.DeleteRestApiDto;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/management"})
@Transactional
public class ManagementController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagementController.class);
    private final TeamRepository teamRepository;
    private final SystemRepository systemRepository;
    private final RestApiRelationRepository restApiRelationRepository;

    @PostMapping(value={"/system"})
    public ResponseEntity<Void> createSystem(@RequestBody CreateSystemDto createSystemDto) {
        String systemName = createSystemDto.getName();
        log.info("Store new System with name '{}'", (Object)systemName);
        if (this.systemRepository.findByNameOrAliasIgnoreCase(systemName).isPresent()) {
            log.error("System with name or alias '{}' already exists. Did not create a new system.", (Object)systemName);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "System with name or alias already exists.");
        }
        System system = System.builder().name(systemName).description(createSystemDto.getDescription()).confluenceLink(createSystemDto.getConfluenceLink()).defaultOwner(this.getOrCreateTeam(createSystemDto.getTeamName())).aliases(createSystemDto.getAliases()).build();
        this.systemRepository.save((Object)system);
        log.info("Created a new system with name '{}'.", (Object)systemName);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    private Team getOrCreateTeam(String teamName) {
        log.info("Get Team with name '{}'", (Object)teamName);
        Optional team = this.teamRepository.findByName(teamName);
        if (team.isPresent()) {
            return (Team)team.get();
        }
        log.info("Team not found. Save a new Team with name '{}'", (Object)teamName);
        return (Team)this.teamRepository.save((Object)Team.builder().name(teamName).build());
    }

    @PostMapping(value={"/team"})
    public void createTeam(String name, @RequestParam(required=false) String contactAddress, @RequestParam(required=false) String confluenceLink, @RequestParam(required=false) String jiraLink) {
        log.info("Save Team with name '{}'", (Object)name);
        Team team = Team.builder().name(name).contactAddress(contactAddress).confluenceLink(confluenceLink).jiraLink(jiraLink).build();
        this.teamRepository.save((Object)team);
    }

    @DeleteMapping(value={"/rest-api"})
    public ResponseEntity<String> deleteRestApi(@RequestBody @Valid DeleteRestApiDto dto) {
        log.info("Delete RestApi relation: {}", (Object)dto);
        List relations = this.restApiRelationRepository.findAllByProviderNameAndConsumerNameAndStatus(dto.getProviderName(), dto.getConsumerName(), RelationStatus.ACTIVE);
        log.info("Found {} RestApi relations between {} and {}", new Object[]{relations.size(), dto.getProviderName(), dto.getConsumerName()});
        Optional<RestApiRelation> relationOptional = relations.stream().filter(relation -> dto.getPath().equalsIgnoreCase(relation.getRestApi().getPath()) && dto.getMethod().equalsIgnoreCase(relation.getRestApi().getMethod())).findFirst();
        if (relationOptional.isPresent()) {
            log.info("Delete RestApi relation: {}", (Object)relationOptional.get());
            relationOptional.get().markDeleted();
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)"Relation deleted successfully");
        }
        log.info("No relations found for method '{}' and path '{}'", (Object)dto.getMethod(), (Object)dto.getPath());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)"No relations found");
    }

    @ConstructorProperties(value={"teamRepository", "systemRepository", "restApiRelationRepository"})
    @Generated
    public ManagementController(TeamRepository teamRepository, SystemRepository systemRepository, RestApiRelationRepository restApiRelationRepository) {
        this.teamRepository = teamRepository;
        this.systemRepository = systemRepository;
        this.restApiRelationRepository = restApiRelationRepository;
    }
}

