/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.database;

import ch.admin.bit.jeap.archrepo.metamodel.database.SystemComponentDatabaseSchema;
import ch.admin.bit.jeap.archrepo.model.database.DatabaseSchema;
import ch.admin.bit.jeap.archrepo.persistence.SystemComponentDatabaseSchemaRepository;
import ch.admin.bit.jeap.archrepo.persistence.SystemComponentRepository;
import ch.admin.bit.jeap.archrepo.web.rest.database.DatabaseSchemaDto;
import ch.admin.bit.jeap.archrepo.web.rest.database.DatabaseSchemaException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/external-api/dbschemas"})
@Tag(name="external-dbschemas", description="External access to database schema definitions associated with system components")
class ExternalDatabaseSchemaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalDatabaseSchemaController.class);
    private final SystemComponentRepository systemComponentRepository;
    private final SystemComponentDatabaseSchemaRepository systemComponentDatabaseSchemaRepository;

    @Transactional
    @GetMapping(produces={"application/json"})
    @Operation(summary="Get the database schema definition associated with a system component.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Database schema retrieved successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchemaDto.class))}), @ApiResponse(responseCode="404", description="No database schema found for the specified system component or the queried system component doesn't exist."), @ApiResponse(responseCode="500", description="Unexpected server error.")})
    @PreAuthorize(value="hasRole('external-database-schema', 'read')")
    public ResponseEntity<DatabaseSchemaDto> getDatabaseSchema(@Parameter(description="Name of the system component to retrieve the database schema for", required=true) @RequestParam String systemComponentName) {
        try {
            SystemComponentDatabaseSchema systemComponentDatabaseSchema = this.getSystemComponentDatabaseSchema(systemComponentName);
            if (systemComponentDatabaseSchema == null) {
                log.debug("No database schema found for the system component '{}'.", (Object)systemComponentName);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
            }
            DatabaseSchemaDto schemaDto = DatabaseSchemaDto.builder().systemComponentName(systemComponentName).schema(this.getDatabaseSchema(systemComponentDatabaseSchema)).build();
            return ResponseEntity.ok((Object)schemaDto);
        }
        catch (Exception e) {
            log.error("Unexpected error while fetching the database schema for the component '{}'.", (Object)systemComponentName, (Object)e);
            throw DatabaseSchemaException.unexpectedError(systemComponentName, e);
        }
    }

    private SystemComponentDatabaseSchema getSystemComponentDatabaseSchema(String systemComponentName) {
        return this.systemComponentRepository.findByNameIgnoreCase(systemComponentName).flatMap(arg_0 -> ((SystemComponentDatabaseSchemaRepository)this.systemComponentDatabaseSchemaRepository).findBySystemComponent(arg_0)).orElse(null);
    }

    private DatabaseSchema getDatabaseSchema(SystemComponentDatabaseSchema systemComponentDatabaseSchema) {
        try {
            return DatabaseSchema.fromJson((byte[])systemComponentDatabaseSchema.getSchema());
        }
        catch (Exception e) {
            throw DatabaseSchemaException.schemaDeserializationError(systemComponentDatabaseSchema.getSystem().getName(), systemComponentDatabaseSchema.getSystemComponent().getName(), e);
        }
    }

    @ConstructorProperties(value={"systemComponentRepository", "systemComponentDatabaseSchemaRepository"})
    @Generated
    public ExternalDatabaseSchemaController(SystemComponentRepository systemComponentRepository, SystemComponentDatabaseSchemaRepository systemComponentDatabaseSchemaRepository) {
        this.systemComponentRepository = systemComponentRepository;
        this.systemComponentDatabaseSchemaRepository = systemComponentDatabaseSchemaRepository;
    }
}

