/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.config;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
public class WebSecurityConfig {
    @Value(value="${archrepo.api.secret}")
    private String apiSecret;

    @Bean
    @Order(value=100)
    SecurityFilterChain apiSecurityFilterChain(HttpSecurity http) throws Exception {
        PathPatternRequestMatcher.Builder api = PathPatternRequestMatcher.withDefaults().basePath("/api");
        AndRequestMatcher apiExcludedDatabaseSchemaExcludedOpenApiPostWithBearerAuth = new AndRequestMatcher(new RequestMatcher[]{api.matcher("/**"), new NegatedRequestMatcher((RequestMatcher)api.matcher("/dbschemas/**")), new NegatedRequestMatcher(this.postToOpenApiWithBearerTokenRequestMatcher(api))});
        http.securityMatcher((RequestMatcher)apiExcludedDatabaseSchemaExcludedOpenApiPostWithBearerAuth);
        http.authorizeHttpRequests(r -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)r.requestMatchers(HttpMethod.GET, new String[]{"/api/model"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/model/*/relations"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/model/rest-api-relation-without-pact"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/model/system-components-without-open-api-spec"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/openapi/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/reactions/**"})).permitAll().anyRequest()).hasRole("api"));
        http.csrf(AbstractHttpConfigurer::disable);
        http.httpBasic(Customizer.withDefaults());
        http.authenticationManager(this.createApiAuthManager((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)));
        return (SecurityFilterChain)http.build();
    }

    private RequestMatcher postToOpenApiWithBearerTokenRequestMatcher(PathPatternRequestMatcher.Builder api) {
        return new AndRequestMatcher(new RequestMatcher[]{api.matcher("/openapi/**"), this::isPostWithBearerAuth});
    }

    private boolean isPostWithBearerAuth(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        boolean isBearerAuth = authHeader != null && authHeader.startsWith("Bearer ");
        boolean isPost = HttpMethod.POST.matches(request.getMethod());
        return isPost && isBearerAuth;
    }

    private AuthenticationManager createApiAuthManager(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser("api").password(this.apiSecret).roles(new String[]{"api"});
        return (AuthenticationManager)auth.build();
    }
}

