/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.service;

import ch.admin.bit.jeap.archrepo.docgen.DocumentationGenerator;
import ch.admin.bit.jeap.archrepo.importers.ArchRepoImporter;
import ch.admin.bit.jeap.archrepo.metamodel.ArchitectureModel;
import ch.admin.bit.jeap.archrepo.persistence.ArchitectureModelRepository;
import ch.admin.bit.jeap.archrepo.web.ArchRepoConfigProperties;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import net.javacrumbs.shedlock.core.LockAssert;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateService.class);
    private LocalDateTime lastRunGenerateDoc = LocalDateTime.MIN;
    private LocalDateTime lastRunUpdateModel = LocalDateTime.MIN;
    private final ArchitectureModelRepository repository;
    private final DocumentationGenerator documentationGenerator;
    private final List<ArchRepoImporter> importers;
    private final MeterRegistry meterRegistry;
    private final ArchRepoConfigProperties archRepoConfigProperties;

    @Timed(value="archrepo_generate_documentation")
    @Scheduled(cron="${archrepo.documentation-generator.update-schedule}")
    @SchedulerLock(name="generate-documentation-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Transactional
    public void generateDocumentation() {
        log.info("Starting scheduled documentation generation");
        LockAssert.assertLocked();
        ArchitectureModel architectureModel = this.repository.load();
        this.documentationGenerator.generate(architectureModel);
        this.lastRunGenerateDoc = LocalDateTime.now();
        log.info("Scheduled documentation generation done");
    }

    @Timed(value="archrepo_model_update")
    @Scheduled(cron="${archrepo.update-schedule}")
    @SchedulerLock(name="update-model-task", lockAtLeastFor="5s", lockAtMostFor="2h")
    @Transactional
    public void updateModel() {
        log.info("Starting scheduled model update");
        LockAssert.assertLocked();
        ArchitectureModel architectureModel = this.repository.load();
        this.importers.stream().sorted(Comparator.comparing(ArchRepoImporter::getOrder)).forEach(importer -> importer.importIntoModel(architectureModel, this.archRepoConfigProperties.getEnvironment().name().toLowerCase()));
        architectureModel.cleanup();
        this.repository.save(architectureModel);
        this.lastRunUpdateModel = LocalDateTime.now();
        log.info("Scheduled model update done");
    }

    @Transactional
    public void runImporter(String name) {
        ArchRepoImporter importer = this.importers.stream().filter(i -> i.getClass().getSimpleName().equalsIgnoreCase(name)).findFirst().orElseThrow();
        log.info("Running importer {}", (Object)importer);
        ArchitectureModel architectureModel = this.repository.load();
        importer.importIntoModel(architectureModel, this.archRepoConfigProperties.getEnvironment().name().toLowerCase());
        this.repository.save(architectureModel);
        log.info("Import done");
    }

    private long calculateDaysFromLastRunToNow(LocalDateTime lastRun) {
        return Duration.between(lastRun, LocalDateTime.now()).toDays();
    }

    @PostConstruct
    private void createMonitoringMetrics() {
        Gauge.builder((String)"archrepo_generate_documentation_last_run_from", () -> this.calculateDaysFromLastRunToNow(this.lastRunGenerateDoc)).baseUnit("days").register(this.meterRegistry);
        Gauge.builder((String)"archrepo_model_update_last_run_from", () -> this.calculateDaysFromLastRunToNow(this.lastRunUpdateModel)).baseUnit("days").register(this.meterRegistry);
    }

    @Generated
    public UpdateService(ArchitectureModelRepository repository, DocumentationGenerator documentationGenerator, List<ArchRepoImporter> importers, MeterRegistry meterRegistry, ArchRepoConfigProperties archRepoConfigProperties) {
        this.repository = repository;
        this.documentationGenerator = documentationGenerator;
        this.importers = importers;
        this.meterRegistry = meterRegistry;
        this.archRepoConfigProperties = archRepoConfigProperties;
    }
}

