/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.reaction;

import ch.admin.bit.jeap.archrepo.persistence.ComponentGraphRepository;
import ch.admin.bit.jeap.archrepo.web.rest.model.ReactionLastModifiedAtDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/reactions"})
class ReactionApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionApiController.class);
    private final ComponentGraphRepository componentGraphRepository;

    @Transactional(readOnly=true)
    @GetMapping(value={"/components"}, produces={"application/json"})
    @Operation(summary="Get the last modified date of observed reactions for all system components.")
    @ApiResponses(value={@ApiResponse(responseCode="200", content={@Content(mediaType="application/json")})})
    public List<ReactionLastModifiedAtDto> getComponentsWithReactions() {
        log.debug("Retrieving all components with observed reactions...");
        return this.componentGraphRepository.getMaxCreatedAndModifiedAtList().stream().map(row -> new ReactionLastModifiedAtDto(row.getComponent(), row.getMaxCreatedAt().isAfter(row.getMaxModifiedAt()) ? row.getMaxCreatedAt() : row.getMaxModifiedAt())).toList();
    }

    @ConstructorProperties(value={"componentGraphRepository"})
    @Generated
    public ReactionApiController(ComponentGraphRepository componentGraphRepository) {
        this.componentGraphRepository = componentGraphRepository;
    }
}

