/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.archrepo.web.rest.database;

import ch.admin.bit.jeap.archrepo.metamodel.database.SystemComponentDatabaseSchema;
import ch.admin.bit.jeap.archrepo.metamodel.system.SystemComponent;
import ch.admin.bit.jeap.archrepo.persistence.DatabaseSchemaVersion;
import ch.admin.bit.jeap.archrepo.persistence.SystemComponentDatabaseSchemaRepository;
import ch.admin.bit.jeap.archrepo.web.rest.database.CreateOrUpdateDbSchemaDto;
import ch.admin.bit.jeap.archrepo.web.rest.database.DatabaseSchemaException;
import ch.admin.bit.jeap.archrepo.web.service.SystemComponentService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dbschemas"})
@Tag(name="dbschemas", description="Manage the data base schema definitions associated with system components")
class DatabaseSchemaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseSchemaController.class);
    private final SystemComponentService systemComponentService;
    private final SystemComponentDatabaseSchemaRepository systemComponentDatabaseSchemaRepository;
    private final PlatformTransactionManager transactionManager;

    @Transactional
    @PostMapping(consumes={"application/json"})
    @Operation(summary="Create or update the database schema definition associated with a system component.")
    @io.swagger.v3.oas.annotations.parameters.RequestBody(required=true, description="The database schema definition to create or update.", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateOrUpdateDbSchemaDto.class))})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Database schema created successfully."), @ApiResponse(responseCode="200", description="Database schema updated successfully."), @ApiResponse(responseCode="400", description="Invalid input data, e.g. database schema is not valid."), @ApiResponse(responseCode="500", description="Unexpected server error.")})
    @PreAuthorize(value="hasRole('database-schema', 'write')")
    public ResponseEntity<Void> createOrUpdateDatabaseSchema(@Valid @RequestBody CreateOrUpdateDbSchemaDto schemaDto) {
        try {
            SystemComponent systemComponent = this.systemComponentService.findOrCreateSystemComponent(schemaDto.getSystemComponentName());
            ResponseEntity response = this.updateDatabaseSchema(schemaDto, systemComponent).orElseGet(() -> this.createDatabaseSchema(schemaDto, systemComponent));
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("Received database schema for the system component '{}' in version '{}'.", (Object)schemaDto.getSystemComponentName(), (Object)schemaDto.getSchema().version());
            }
            return response;
        }
        catch (DatabaseSchemaException e) {
            log.error("Updating or creating the database schema '{}' failed.", (Object)schemaDto, (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error while updating or creating the database schema '{}'.", (Object)schemaDto, (Object)e);
            throw DatabaseSchemaException.unexpectedError(schemaDto, e);
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"/versions"}, produces={"application/json"})
    @Operation(summary="Get the database schema versions of all system components.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The database schema versions of all system components.", content={@Content(mediaType="application/json")})})
    public List<DatabaseSchemaVersion> getDatabaseSchemaVersions() {
        log.debug("Retrieving database schema versions.");
        List versions = this.systemComponentDatabaseSchemaRepository.getDatabaseSchemaVersions();
        log.debug("Returning database schema versions for '{}' system components", (Object)versions.size());
        return versions;
    }

    private Optional<ResponseEntity<Void>> updateDatabaseSchema(CreateOrUpdateDbSchemaDto schemaDto, SystemComponent systemComponent) {
        return this.systemComponentDatabaseSchemaRepository.findBySystemComponent(systemComponent).map(databaseSchema -> databaseSchema.update(this.getJsonSchema(schemaDto), schemaDto.getSchema().version())).map(databaseSchema -> ResponseEntity.status((HttpStatusCode)HttpStatus.OK).build());
    }

    private ResponseEntity<Void> createDatabaseSchema(CreateOrUpdateDbSchemaDto schemaDto, SystemComponent systemComponent) {
        SystemComponentDatabaseSchema databaseSchema = SystemComponentDatabaseSchema.builder().systemComponent(systemComponent).schema(this.getJsonSchema(schemaDto)).schemaVersion(schemaDto.getSchema().version()).build();
        try {
            this.systemComponentDatabaseSchemaRepository.saveAndFlush((Object)databaseSchema);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        catch (DataIntegrityViolationException dive) {
            return this.withinNewTransactionWithResult(() -> this.updateDatabaseSchema(schemaDto, systemComponent).orElseThrow(() -> DatabaseSchemaException.unexpectedError(schemaDto, "Expected the database schema to be present.")));
        }
    }

    private byte[] getJsonSchema(CreateOrUpdateDbSchemaDto schemaDto) {
        try {
            return schemaDto.getSchema().toJson();
        }
        catch (Exception e) {
            log.error("Failed to serialize the schema {} to JSON.", (Object)schemaDto, (Object)e);
            throw DatabaseSchemaException.schemaSerializationError(schemaDto, e);
        }
    }

    private <V> V withinNewTransactionWithResult(Supplier<V> callback) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        return (V)transactionTemplate.execute(status -> callback.get());
    }

    @ConstructorProperties(value={"systemComponentService", "systemComponentDatabaseSchemaRepository", "transactionManager"})
    @Generated
    public DatabaseSchemaController(SystemComponentService systemComponentService, SystemComponentDatabaseSchemaRepository systemComponentDatabaseSchemaRepository, PlatformTransactionManager transactionManager) {
        this.systemComponentService = systemComponentService;
        this.systemComponentDatabaseSchemaRepository = systemComponentDatabaseSchemaRepository;
        this.transactionManager = transactionManager;
    }
}

