/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.adapter.testagent;

import ch.admin.bit.jeap.testagent.api.act.ActionDto;
import ch.admin.bit.jeap.testagent.api.act.ActionResultDto;
import ch.admin.bit.jeap.testagent.api.prepare.PreparationDto;
import ch.admin.bit.jeap.testagent.api.prepare.PreparationResultDto;
import ch.admin.bit.jeap.testagent.api.update.DynamicDataDto;
import ch.admin.bit.jeap.testagent.api.verify.ReportDto;
import ch.admin.bit.jeap.testorchestrator.adapter.testagent.TestAgentException;
import ch.admin.bit.jeap.testorchestrator.adapter.testagent.TestAgentsConfig;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@Component
public class TestAgentWebClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestAgentWebClient.class);
    private final RestClient restClient;
    private final Map<String, String> testAgentsMap;
    private final Duration readTimeout;
    private static final String API_PATH = "/api/tests/";
    private static final int TIMEOUT_5_SECONDS = 5;
    public static final String IS_4_XX_ERROR = "is4xxClientError; TestAgent: ";
    public static final String IS_5_XX_ERROR = "is5xxServerError; TestAgent: ";
    public static final String ERR_MSG = "Could not connect or timeout to TestAgent: ";

    public TestAgentWebClient(RestClient.Builder restClientBuilder, TestAgentsConfig testAgentsConfig) {
        this.testAgentsMap = testAgentsConfig.getTestAgentURLs();
        this.readTimeout = Duration.ofSeconds(testAgentsConfig.getReadTimeout(5));
        this.restClient = this.createRestClient(restClientBuilder);
    }

    private RestClient createRestClient(RestClient.Builder restClientBuilder) {
        ClientHttpRequestFactory timeoutRequestFactory = ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)ClientHttpRequestFactorySettings.DEFAULTS.withReadTimeout(this.readTimeout));
        return restClientBuilder.requestFactory(timeoutRequestFactory).build();
    }

    public PreparationResultDto prepare(String testAgentName, String testId, PreparationDto preparationDto) {
        String testAgentURL = this.testAgentsMap.get(testAgentName);
        log.info("Prepare {} for test {}: Put {} with url {}", new Object[]{StructuredArguments.value((String)"testAgentName", (Object)testAgentName), StructuredArguments.value((String)"testId", (Object)testId), preparationDto, testAgentURL});
        try {
            return (PreparationResultDto)((RestClient.RequestBodySpec)this.restClient.put().uri(testAgentURL + API_PATH + testId, new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)preparationDto).exchange((clientRequest, clientResponse) -> {
                this.handleError(clientResponse, testId, testAgentName, testAgentURL);
                return (PreparationResultDto)clientResponse.bodyTo(PreparationResultDto.class);
            });
        }
        catch (Exception e) {
            throw this.mapException(e, testId, testAgentName, testAgentURL);
        }
    }

    public ActionResultDto act(String testAgentName, String testId, ActionDto actionDto) {
        String testAgentURL = this.testAgentsMap.get(testAgentName);
        log.info("Act on {} for test {}: Put {} with url {}", new Object[]{StructuredArguments.value((String)"testAgentName", (Object)testAgentName), StructuredArguments.value((String)"testId", (Object)testId), actionDto, testAgentURL});
        try {
            return (ActionResultDto)((RestClient.RequestBodySpec)this.restClient.post().uri(testAgentURL + API_PATH + testId + "/actions", new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)actionDto).exchange((clientRequest, clientResponse) -> {
                this.handleError(clientResponse, testId, testAgentName, testAgentURL);
                return (ActionResultDto)clientResponse.bodyTo(ActionResultDto.class);
            });
        }
        catch (Exception e) {
            throw this.mapException(e, testId, testAgentName, testAgentURL);
        }
    }

    public void update(String testAgentName, String testId, DynamicDataDto dynamicDataDto) {
        String testAgentURL = this.testAgentsMap.get(testAgentName);
        log.info("Update {} for test {}: Put {} with url {}", new Object[]{StructuredArguments.value((String)"testAgentName", (Object)testAgentName), StructuredArguments.value((String)"testId", (Object)testId), dynamicDataDto, testAgentURL});
        try {
            ((RestClient.RequestBodySpec)this.restClient.put().uri(testAgentURL + API_PATH + testId + "/dynamicdata", new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)dynamicDataDto).exchange((clientRequest, clientResponse) -> {
                this.handleError(clientResponse, testId, testAgentName, testAgentURL);
                return (Void)clientResponse.bodyTo(Void.class);
            });
        }
        catch (Exception e) {
            throw this.mapException(e, testId, testAgentName, testAgentURL);
        }
    }

    public ReportDto verify(String testAgentName, String testId) {
        String testAgentURL = this.testAgentsMap.get(testAgentName);
        log.info("Verify {} for test {} with url {}", new Object[]{StructuredArguments.value((String)"testAgentName", (Object)testAgentName), StructuredArguments.value((String)"testId", (Object)testId), testAgentURL});
        try {
            return (ReportDto)this.restClient.get().uri(testAgentURL + API_PATH + testId + "/report", new Object[0]).exchange((clientRequest, clientResponse) -> {
                this.handleError(clientResponse, testId, testAgentName, testAgentURL);
                return (ReportDto)clientResponse.bodyTo(ReportDto.class);
            });
        }
        catch (Exception e) {
            throw this.mapException(e, testId, testAgentName, testAgentURL);
        }
    }

    public void delete(String testAgentName, String testId) {
        String testAgentURL = this.testAgentsMap.get(testAgentName);
        log.info("Delete on {} for test {} with url {}", new Object[]{StructuredArguments.value((String)"testAgentName", (Object)testAgentName), StructuredArguments.value((String)"testId", (Object)testId), testAgentURL});
        try {
            this.restClient.delete().uri(testAgentURL + API_PATH + testId, new Object[0]).exchange((clientRequest, clientResponse) -> {
                this.handleError(clientResponse, testId, testAgentName, testAgentURL);
                return (Void)clientResponse.bodyTo(Void.class);
            });
        }
        catch (Exception e) {
            throw this.mapException(e, testId, testAgentName, testAgentURL);
        }
    }

    private void handleError(RestClient.RequestHeadersSpec.ConvertibleClientHttpResponse clientHttpResponse, String testId, String testAgentName, String testAgentURL) throws IOException {
        HttpStatusCode httpStatusCode = clientHttpResponse.getStatusCode();
        if (httpStatusCode.is4xxClientError()) {
            throw new TestAgentException(testId, testAgentName, testAgentURL, IS_4_XX_ERROR + testAgentName);
        }
        if (httpStatusCode.is5xxServerError()) {
            throw new TestAgentException(testId, testAgentName, testAgentURL, IS_5_XX_ERROR + testAgentName);
        }
    }

    private RuntimeException mapException(Exception e, String testId, String testAgentName, String testAgentURL) {
        if (e instanceof TestAgentException) {
            TestAgentException tae = (TestAgentException)e;
            throw tae;
        }
        return new TestAgentException(testId, testAgentName, testAgentURL, ERR_MSG + testAgentName);
    }
}

