/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.adapter.zephyr;

import ch.admin.bit.jeap.testorchestrator.adapter.zephyr.ZephyrTestRunDto;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@Component
public class ZephyrWebClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZephyrWebClient.class);
    private final RestClient restClient;
    private final String restApiUrl;

    public ZephyrWebClient(@Value(value="${orchestrator.zephyr.username}") String username, @Value(value="${orchestrator.zephyr.password}") String password, @Value(value="${orchestrator.zephyr.restApiUrl}") String restApiUrl) {
        this.restApiUrl = restApiUrl;
        ClientHttpRequestFactory requestFactory = ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)ClientHttpRequestFactorySettings.DEFAULTS.withReadTimeout(Duration.ofSeconds(10L)));
        this.restClient = RestClient.builder().defaultHeaders(header -> header.setBasicAuth(username, password)).requestFactory(requestFactory).requestInterceptor(this::logRequest).build();
    }

    private ClientHttpResponse logRequest(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Calling Zephyr: {} {} with headers [{}] and body {}.", new Object[]{request.getMethod(), request.getURI(), request.getHeaders().toSingleValueMap().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (((String)entry.getKey()).equals("Authorization") ? "*******" : (String)entry.getValue())).collect(Collectors.joining(", ")), new String(body, StandardCharsets.UTF_8)});
        }
        return execution.execute(request, body);
    }

    public void testrun(ZephyrTestRunDto zephyrTestRunDto) {
        String uri = this.restApiUrl + "/testrun";
        log.info("Posting to Zephyr at {}: {}", (Object)uri, (Object)zephyrTestRunDto);
        ((RestClient.RequestBodySpec)this.restClient.post().uri(uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).body((Object)zephyrTestRunDto).retrieve().toBodilessEntity();
    }
}

