/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.metrics;

import ch.admin.bit.jeap.testorchestrator.adapter.jpa.TestCaseJpaRepository;
import ch.admin.bit.jeap.testorchestrator.adapter.jpa.TestRunJpaRepository;
import ch.admin.bit.jeap.testorchestrator.domain.TestCase;
import ch.admin.bit.jeap.testorchestrator.domain.TestConclusion;
import ch.admin.bit.jeap.testorchestrator.domain.TestRun;
import ch.admin.bit.jeap.testorchestrator.domain.TestState;
import ch.admin.bit.jeap.testorchestrator.metrics.TestCaseMetricsDto;
import ch.admin.bit.jeap.testorchestrator.metrics.TestRunMetricsDto;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TestCaseMetricsService {
    private final TestCaseJpaRepository testCaseJpaRepository;
    private final TestRunJpaRepository testRunJpaRepository;

    @Transactional(readOnly=true)
    public List<TestCaseMetricsDto> getAllTestCaseMetrics() {
        return this.testCaseJpaRepository.findAll().stream().map(testCase -> {
            List<TestRun> testRunList = this.testRunJpaRepository.findByTestCase((TestCase)testCase);
            TestRunMetricsDto testRunMetricsDto = this.calculateTestRuns(testRunList);
            return new TestCaseMetricsDto(testCase.getName(), testRunMetricsDto.totalTestRuns(), testRunMetricsDto.successfulTestRuns(), testRunMetricsDto.failedTestRuns(), testRunMetricsDto.formattedAverageSuccessDuration(), testRunMetricsDto.formattedAverageFailedDuration());
        }).collect(Collectors.toList());
    }

    private TestRunMetricsDto calculateTestRuns(List<TestRun> testRunList) {
        AtomicInteger numberOfTestRuns = new AtomicInteger();
        AtomicInteger failedTestRuns = new AtomicInteger();
        AtomicInteger successfulTestRuns = new AtomicInteger();
        ArrayList<TestRun> successfulFullTestRunList = new ArrayList<TestRun>(List.of());
        ArrayList<TestRun> failedTestRunList = new ArrayList<TestRun>(List.of());
        testRunList.forEach(testRun -> {
            TestState testState = testRun.getTestState();
            if (TestState.ABORTED.equals((Object)testState)) {
                failedTestRuns.getAndIncrement();
                numberOfTestRuns.getAndIncrement();
                failedTestRunList.add((TestRun)testRun);
            } else if (TestState.ENDED.equals((Object)testState)) {
                TestConclusion testConclusion = testRun.getTestReport().getOverallTestConclusion();
                if (testConclusion.equals((Object)TestConclusion.FAIL)) {
                    failedTestRuns.getAndIncrement();
                    numberOfTestRuns.getAndIncrement();
                    failedTestRunList.add((TestRun)testRun);
                } else if (testConclusion.equals((Object)TestConclusion.PASS)) {
                    successfulTestRuns.getAndIncrement();
                    numberOfTestRuns.getAndIncrement();
                    successfulFullTestRunList.add((TestRun)testRun);
                } else if (testConclusion.equals((Object)TestConclusion.NO_RESULT)) {
                    failedTestRuns.getAndIncrement();
                    numberOfTestRuns.getAndIncrement();
                    failedTestRunList.add((TestRun)testRun);
                }
            }
        });
        return new TestRunMetricsDto(numberOfTestRuns.get(), successfulTestRuns.get(), failedTestRuns.get(), this.averageTestTime(successfulFullTestRunList), this.averageTestTime(failedTestRunList));
    }

    private Duration averageTestTime(List<TestRun> testRunList) {
        List<Duration> durationList = testRunList.stream().filter(testRun -> testRun.getEndedAt() != null).map(testRun -> Duration.between(testRun.getStartedAt(), testRun.getEndedAt())).toList();
        Duration totalDuration = Duration.ZERO;
        for (Duration duration : durationList) {
            totalDuration = totalDuration.plus(duration);
        }
        if (durationList.size() == 0) {
            return Duration.ZERO;
        }
        return totalDuration.dividedBy(durationList.size());
    }

    @Generated
    public TestCaseMetricsService(TestCaseJpaRepository testCaseJpaRepository, TestRunJpaRepository testRunJpaRepository) {
        this.testCaseJpaRepository = testCaseJpaRepository;
        this.testRunJpaRepository = testRunJpaRepository;
    }
}

