/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.testsupport;

import ch.admin.bit.jeap.testagent.api.act.ActionDto;
import ch.admin.bit.jeap.testagent.api.act.ActionResultDto;
import ch.admin.bit.jeap.testagent.api.prepare.PreparationDto;
import ch.admin.bit.jeap.testagent.api.prepare.PreparationResultDto;
import ch.admin.bit.jeap.testagent.api.update.DynamicDataDto;
import ch.admin.bit.jeap.testagent.api.verify.ReportDto;
import ch.admin.bit.jeap.testorchestrator.adapter.testagent.TestAgentWebClient;
import ch.admin.bit.jeap.testorchestrator.services.TestReportService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCaseMockTool {
    @NonNull
    private final TestAgentWebClient testAgentWebClientMock;
    @NonNull
    private final TestReportService testReportServiceMock;
    @NonNull
    private final String testId;
    @NonNull
    private final String callBackBaseUrl;

    public void mockPrepareCall(String testAgentName, PreparationResultDto preparationResultDto) {
        Mockito.when((Object)this.testAgentWebClientMock.prepare((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId), (PreparationDto)ArgumentMatchers.any())).thenReturn((Object)preparationResultDto);
    }

    public PreparationDto assertPrepareCalled(String testAgentName, String testCase) {
        ArgumentCaptor preparationDtoCaptor = ArgumentCaptor.forClass(PreparationDto.class);
        ((TestAgentWebClient)Mockito.verify((Object)this.testAgentWebClientMock)).prepare((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId), (PreparationDto)preparationDtoCaptor.capture());
        PreparationDto preparationDto = (PreparationDto)preparationDtoCaptor.getValue();
        Assertions.assertNotNull((Object)preparationDto);
        Assertions.assertEquals((Object)testCase, (Object)preparationDto.getTestCase());
        Assertions.assertEquals((Object)this.callBackBaseUrl, (Object)preparationDto.getCallbackBaseUrl());
        return preparationDto;
    }

    public void mockActCall(String testAgentName, Supplier<ActionResultDto> act) {
        ((TestAgentWebClient)Mockito.doAnswer(invocation -> act.get()).when((Object)this.testAgentWebClientMock)).act((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId), (ActionDto)ArgumentMatchers.any());
    }

    public void mockActCall(String testAgentName, ActionDto actionDto, Supplier<ActionResultDto> act) {
        ((TestAgentWebClient)Mockito.doAnswer(invocation -> act.get()).when((Object)this.testAgentWebClientMock)).act((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId), (ActionDto)ArgumentMatchers.eq((Object)actionDto));
    }

    public ActionDto assertActCalled(String testAgentName, String action) {
        ArgumentCaptor actionDtoCaptor = ArgumentCaptor.forClass(ActionDto.class);
        ((TestAgentWebClient)Mockito.verify((Object)this.testAgentWebClientMock)).act((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId), (ActionDto)actionDtoCaptor.capture());
        ActionDto actionDto = (ActionDto)actionDtoCaptor.getValue();
        Assertions.assertNotNull((Object)actionDto);
        Assertions.assertEquals((Object)action, (Object)actionDto.getAction());
        return actionDto;
    }

    public List<ActionDto> assertActsCalled(String testAgentName, String ... actions) {
        ArgumentCaptor actionDtoCaptor = ArgumentCaptor.forClass(ActionDto.class);
        ((TestAgentWebClient)Mockito.verify((Object)this.testAgentWebClientMock, (VerificationMode)Mockito.times((int)actions.length))).act((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId), (ActionDto)actionDtoCaptor.capture());
        List capturedActionDtos = actionDtoCaptor.getAllValues();
        capturedActionDtos.forEach(Assertions::assertNotNull);
        Set capturedActions = capturedActionDtos.stream().map(ActionDto::getAction).collect(Collectors.toSet());
        HashSet<String> actionSet = new HashSet<String>(Arrays.asList(actions));
        Assertions.assertEquals(actionSet, capturedActions);
        return capturedActionDtos;
    }

    public DynamicDataDto assertUpdateCalled(String testAgentName) {
        ArgumentCaptor dynamicDataDtoCaptor = ArgumentCaptor.forClass(DynamicDataDto.class);
        ((TestAgentWebClient)Mockito.verify((Object)this.testAgentWebClientMock)).update((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId), (DynamicDataDto)dynamicDataDtoCaptor.capture());
        DynamicDataDto dynamicDataDto = (DynamicDataDto)dynamicDataDtoCaptor.getValue();
        Assertions.assertNotNull((Object)dynamicDataDto);
        return dynamicDataDto;
    }

    public void assertVerifyCalled(String ... testAgentNames) {
        Arrays.stream(testAgentNames).forEach(testAgentName -> ((TestAgentWebClient)Mockito.verify((Object)this.testAgentWebClientMock)).verify((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId)));
    }

    public List<ReportDto> assertPersistTestResultCalled(int times) {
        ArgumentCaptor reportDtoCaptor = ArgumentCaptor.forClass(ReportDto.class);
        ((TestReportService)Mockito.verify((Object)this.testReportServiceMock, (VerificationMode)Mockito.times((int)times))).persistTestResult((String)ArgumentMatchers.eq((Object)this.testId), (ReportDto)reportDtoCaptor.capture());
        return reportDtoCaptor.getAllValues();
    }

    public void assertDeleteCalled(String ... testAgentNames) {
        Arrays.stream(testAgentNames).forEach(testAgentName -> ((TestAgentWebClient)Mockito.verify((Object)this.testAgentWebClientMock)).delete((String)ArgumentMatchers.eq((Object)testAgentName), (String)ArgumentMatchers.eq((Object)this.testId)));
    }

    public void assertNoMoreTestAgentWebClientInteractions() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.testAgentWebClientMock});
    }

    public void assertNoMoreTestReportServiceInteractions() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.testReportServiceMock});
    }

    @Generated
    TestCaseMockTool(@NonNull TestAgentWebClient testAgentWebClientMock, @NonNull TestReportService testReportServiceMock, @NonNull String testId, @NonNull String callBackBaseUrl) {
        if (testAgentWebClientMock == null) {
            throw new NullPointerException("testAgentWebClientMock is marked non-null but is null");
        }
        if (testReportServiceMock == null) {
            throw new NullPointerException("testReportServiceMock is marked non-null but is null");
        }
        if (testId == null) {
            throw new NullPointerException("testId is marked non-null but is null");
        }
        if (callBackBaseUrl == null) {
            throw new NullPointerException("callBackBaseUrl is marked non-null but is null");
        }
        this.testAgentWebClientMock = testAgentWebClientMock;
        this.testReportServiceMock = testReportServiceMock;
        this.testId = testId;
        this.callBackBaseUrl = callBackBaseUrl;
    }

    @Generated
    public static TestCaseMockToolBuilder builder() {
        return new TestCaseMockToolBuilder();
    }

    @Generated
    public static class TestCaseMockToolBuilder {
        @Generated
        private TestAgentWebClient testAgentWebClientMock;
        @Generated
        private TestReportService testReportServiceMock;
        @Generated
        private String testId;
        @Generated
        private String callBackBaseUrl;

        @Generated
        TestCaseMockToolBuilder() {
        }

        @Generated
        public TestCaseMockToolBuilder testAgentWebClientMock(@NonNull TestAgentWebClient testAgentWebClientMock) {
            if (testAgentWebClientMock == null) {
                throw new NullPointerException("testAgentWebClientMock is marked non-null but is null");
            }
            this.testAgentWebClientMock = testAgentWebClientMock;
            return this;
        }

        @Generated
        public TestCaseMockToolBuilder testReportServiceMock(@NonNull TestReportService testReportServiceMock) {
            if (testReportServiceMock == null) {
                throw new NullPointerException("testReportServiceMock is marked non-null but is null");
            }
            this.testReportServiceMock = testReportServiceMock;
            return this;
        }

        @Generated
        public TestCaseMockToolBuilder testId(@NonNull String testId) {
            if (testId == null) {
                throw new NullPointerException("testId is marked non-null but is null");
            }
            this.testId = testId;
            return this;
        }

        @Generated
        public TestCaseMockToolBuilder callBackBaseUrl(@NonNull String callBackBaseUrl) {
            if (callBackBaseUrl == null) {
                throw new NullPointerException("callBackBaseUrl is marked non-null but is null");
            }
            this.callBackBaseUrl = callBackBaseUrl;
            return this;
        }

        @Generated
        public TestCaseMockTool build() {
            return new TestCaseMockTool(this.testAgentWebClientMock, this.testReportServiceMock, this.testId, this.callBackBaseUrl);
        }

        @Generated
        public String toString() {
            return "TestCaseMockTool.TestCaseMockToolBuilder(testAgentWebClientMock=" + String.valueOf(this.testAgentWebClientMock) + ", testReportServiceMock=" + String.valueOf(this.testReportServiceMock) + ", testId=" + this.testId + ", callBackBaseUrl=" + this.callBackBaseUrl + ")";
        }
    }
}

