/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.services;

import ch.admin.bit.jeap.testagent.api.prepare.PreparationDto;
import ch.admin.bit.jeap.testorchestrator.adapter.jpa.TestCaseJpaRepository;
import ch.admin.bit.jeap.testorchestrator.adapter.testagent.TestAgentException;
import ch.admin.bit.jeap.testorchestrator.domain.TestCase;
import ch.admin.bit.jeap.testorchestrator.domain.TestRun;
import ch.admin.bit.jeap.testorchestrator.domain.events.ExecuteDoneEvent;
import ch.admin.bit.jeap.testorchestrator.domain.events.TestRunFinishedEvent;
import ch.admin.bit.jeap.testorchestrator.services.TestCaseBaseInterface;
import ch.admin.bit.jeap.testorchestrator.services.TestReportService;
import ch.admin.bit.jeap.testorchestrator.services.TestRunService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class TestCaseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestCaseService.class);
    private final Map<String, TestCaseBaseInterface> testCasesMap;
    private final Map<String, Timer> timerMap;
    private final TestReportService testReportService;
    private final TestRunService testRunService;
    private final TestCaseJpaRepository testCaseJpaRepository;
    private final String callbackUrl;
    private final String zephyrEnvironment;
    private final long testRunTimeout;

    public TestCaseService(List<TestCaseBaseInterface> testCases, TestReportService testReportService, TestRunService testRunService, TestCaseJpaRepository testCaseJpaRepository, @Value(value="${orchestrator.callbackUrl}") String callbackUrl, @Value(value="${orchestrator.zephyr.zephyrEnvironment}") String zephyrEnvironment, @Value(value="${orchestrator.testRunTimeout:30000}") long testRunTimeout) {
        this.testCasesMap = testCases.stream().collect(Collectors.toMap(TestCaseBaseInterface::getTestCaseName, Function.identity()));
        this.testReportService = testReportService;
        this.testRunService = testRunService;
        this.testCaseJpaRepository = testCaseJpaRepository;
        this.callbackUrl = callbackUrl;
        this.zephyrEnvironment = zephyrEnvironment;
        this.testRunTimeout = testRunTimeout;
        this.timerMap = new HashMap<String, Timer>();
        testRunService.setTestCasesMap(this.testCasesMap);
    }

    public String startTestRun(String testCaseName) {
        TestCaseBaseInterface testCaseInstance = this.testCasesMap.get(testCaseName);
        if (testCaseInstance == null) {
            throw new IllegalArgumentException("The TestCaseName '" + testCaseName + "' does not fit with an implemented class name");
        }
        TestRun testRun = this.createTestRun(testCaseName, testCaseInstance);
        String testId = testRun.getTestId();
        this.startTimer(testId, testCaseInstance);
        PreparationDto preparationDto = PreparationDto.builder().callbackBaseUrl(this.callbackUrl).testCase(testCaseName).build();
        try {
            testCaseInstance.prepare(testId, preparationDto);
            log.info("Prepared {}", (Object)StructuredArguments.kv((String)"testId", (Object)testRun.getTestId()));
            log.info("testcasename: {}", (Object)testRun.getTestCase().getName());
            log.info("testId: {}", (Object)testRun.getTestId());
            testCaseInstance.execute(testId);
        }
        catch (TestAgentException testAgentException) {
            this.logTestAgentException(testAgentException);
            this.testRunService.abortTestRun(testId, testAgentException.getMessage());
        }
        return testId;
    }

    @EventListener
    public void onApplicationEvent(ExecuteDoneEvent event) {
        TestCaseBaseInterface testCaseInstance = this.testCasesMap.get(event.getTestCaseName());
        String testId = event.getTestId();
        try {
            this.stopTimer(testId);
            testCaseInstance.verify(testId);
            log.info("Verified {}", (Object)StructuredArguments.kv((String)"testId", (Object)testId));
            this.testReportService.reportToJira(testId);
            log.info("Reported {}", (Object)StructuredArguments.kv((String)"testId", (Object)testId));
            testCaseInstance.cleanUp(testId);
            log.info("Cleaned {}", (Object)StructuredArguments.kv((String)"testId", (Object)testId));
        }
        catch (TestAgentException testAgentException) {
            this.logTestAgentException(testAgentException);
            this.testRunService.abortTestRun(testId, testAgentException.getMessage());
        }
    }

    private void logTestAgentException(TestAgentException testAgentException) {
        log.error("[{}] Failed or timed out rest call for '{}'. Abort test run '{}'", new Object[]{StructuredArguments.value((String)"testAgentName", (Object)testAgentException.getTestAgentName()), StructuredArguments.value((String)"requestUrl", (Object)testAgentException.getRequestUrl()), StructuredArguments.value((String)"testId", (Object)testAgentException.getTestId())});
    }

    @EventListener
    public void onApplicationTestRunFinished(TestRunFinishedEvent event) {
        this.testRunService.endTestRun(event.getTestId());
    }

    boolean isTimerRunning(String testId) {
        return this.timerMap.containsKey(testId);
    }

    private TestRun createTestRun(String testCaseName, TestCaseBaseInterface testCaseBaseInterface) {
        Optional<TestCase> testCaseOptional = this.testCaseJpaRepository.findByName(testCaseName);
        TestCase actualTestCase = testCaseOptional.orElseGet(() -> this.createTestCase(testCaseName, testCaseBaseInterface));
        return this.testRunService.createTestRun(this.zephyrEnvironment, actualTestCase);
    }

    private TestCase createTestCase(String testCaseName, TestCaseBaseInterface testCaseBaseInterface) {
        TestCase newTestCase = new TestCase(testCaseName, testCaseBaseInterface.getJiraProjectKey(), testCaseBaseInterface.getZephyrTestCaseKey());
        return (TestCase)this.testCaseJpaRepository.save(newTestCase);
    }

    private void startTimer(String testId, TestCaseBaseInterface testCaseInstance) {
        log.debug("Start timer {} for testcase", (Object)testId, (Object)testCaseInstance.getTestCaseName());
        TestRunTimerTask task = new TestRunTimerTask(testId, this.testRunService);
        Timer timer = new Timer();
        timer.schedule((TimerTask)task, this.testRunTimeout);
        this.timerMap.put(testId, timer);
    }

    private void stopTimer(String testId) {
        Timer timer = this.timerMap.remove(testId);
        if (timer != null) {
            log.debug("Stop timer {}", (Object)testId);
            timer.cancel();
            timer.purge();
        } else {
            log.debug("unexpected: no timer {} to stop", (Object)testId);
        }
    }

    static class TestRunTimerTask
    extends TimerTask {
        private final String testId;
        private final TestRunService testRunService;

        @Override
        public void run() {
            log.info("+++ TestRunTimerTask performed: {}", (Object)this.testId);
            if (this.testRunService.isTestRunInProgress(this.testId)) {
                log.info("Abort the TestRun and Report to JIRA Zephyr");
                this.testRunService.abortLongRunningTestRun(this.testId);
            } else {
                log.info("TestRun has already ended. No Report to JIRA");
            }
        }

        @Generated
        public TestRunTimerTask(String testId, TestRunService testRunService) {
            this.testId = testId;
            this.testRunService = testRunService;
        }
    }
}

