/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.services;

import ch.admin.bit.jeap.testagent.api.verify.Conclusion;
import ch.admin.bit.jeap.testagent.api.verify.ReportDto;
import ch.admin.bit.jeap.testorchestrator.adapter.jpa.TestReportJpaRepository;
import ch.admin.bit.jeap.testorchestrator.adapter.jpa.TestRunJpaRepository;
import ch.admin.bit.jeap.testorchestrator.adapter.zephyr.ZephyrItemDto;
import ch.admin.bit.jeap.testorchestrator.adapter.zephyr.ZephyrStepDto;
import ch.admin.bit.jeap.testorchestrator.adapter.zephyr.ZephyrTestRunDto;
import ch.admin.bit.jeap.testorchestrator.adapter.zephyr.ZephyrWebClient;
import ch.admin.bit.jeap.testorchestrator.domain.TestCase;
import ch.admin.bit.jeap.testorchestrator.domain.TestConclusion;
import ch.admin.bit.jeap.testorchestrator.domain.TestReport;
import ch.admin.bit.jeap.testorchestrator.domain.TestResult;
import ch.admin.bit.jeap.testorchestrator.domain.TestRun;
import ch.admin.bit.jeap.testorchestrator.domain.events.ReportCreatedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class TestReportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestReportService.class);
    private final TestRunJpaRepository testRunJpaRepository;
    private final TestReportJpaRepository testReportJpaRepository;
    private final ZephyrWebClient zephyrWebClient;
    private final PlatformTransactionManager transactionManager;
    private final ApplicationEventPublisher applicationEventPublisher;

    public void persistTestResult(String testId, ReportDto reportDto) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.executeWithoutResult(status -> {
            Optional testReportOptional = this.testReportJpaRepository.findById(UUID.fromString(testId));
            TestReport actualTestReport = testReportOptional.orElseGet(() -> this.createTestReport(testId, reportDto));
            reportDto.getResults().forEach(resultDto -> {
                TestResult testResult = new TestResult(resultDto.getName(), resultDto.getDetail(), TestReportService.convertConclusionEnum(resultDto.getConclusion()));
                actualTestReport.add(testResult);
            });
            this.testReportJpaRepository.save(actualTestReport);
        });
    }

    public void reportToJira(String testId) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.executeWithoutResult(status -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            TestCase testCase = testRun.getTestCase();
            TestReport testReport = testRun.getTestReport();
            List<TestResult> testResultList = testReport.getTestResults();
            ArrayList<ZephyrStepDto> zephyrStepDtoList = new ArrayList<ZephyrStepDto>();
            int index = 0;
            for (TestResult testResult : testResultList) {
                ZephyrStepDto build = ZephyrStepDto.builder().index(index++).status(TestReportService.convertForZepyhr(testResult.getTestConclusion())).comment(testResult.getDetail()).build();
                zephyrStepDtoList.add(build);
            }
            ZephyrItemDto zephyrItemDto = ZephyrItemDto.builder().testCaseKey(testCase.getZepyhrTestCaseKey()).status(TestReportService.convertForZepyhr(testReport.getOverallTestConclusion())).environment(testRun.getEnvironment()).comment(testReport.getDetail()).scriptResults(zephyrStepDtoList).build();
            ZephyrTestRunDto zephyrTestRunDto = ZephyrTestRunDto.builder().name("BusinessProcess Test Cycle").projectKey(testCase.getJiraProjectKey()).items(List.of(zephyrItemDto)).build();
            this.zephyrWebClient.testrun(zephyrTestRunDto);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ReportCreatedEvent(this, testCase.getName(), testId, testReport.getOverallTestConclusion()));
        });
    }

    private TestReport createTestReport(String testId, ReportDto reportDto) {
        TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
        TestReport newTestReport = new TestReport(UUID.fromString(testId), "TestId: " + reportDto.getTestId());
        testRun.setTestReport(newTestReport);
        this.testRunJpaRepository.save(testRun);
        return testRun.getTestReport();
    }

    private static String convertForZepyhr(TestConclusion testConclusion) {
        if (TestConclusion.PASS.equals((Object)testConclusion)) {
            return "Pass";
        }
        return "Fail";
    }

    private static TestConclusion convertConclusionEnum(Conclusion apiConclusion) {
        return switch (apiConclusion) {
            default -> throw new MatchException(null, null);
            case Conclusion.PASS -> TestConclusion.PASS;
            case Conclusion.FAIL -> TestConclusion.FAIL;
        };
    }

    @Generated
    public TestReportService(TestRunJpaRepository testRunJpaRepository, TestReportJpaRepository testReportJpaRepository, ZephyrWebClient zephyrWebClient, PlatformTransactionManager transactionManager, ApplicationEventPublisher applicationEventPublisher) {
        this.testRunJpaRepository = testRunJpaRepository;
        this.testReportJpaRepository = testReportJpaRepository;
        this.zephyrWebClient = zephyrWebClient;
        this.transactionManager = transactionManager;
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

