/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.domain;

import ch.admin.bit.jeap.testorchestrator.domain.TestConclusion;
import ch.admin.bit.jeap.testorchestrator.domain.TestResult;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class TestReport {
    @Id
    @NonNull
    private UUID id;
    @NonNull
    private String detail;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="testReport", orphanRemoval=true)
    private final List<TestResult> testResults = new ArrayList<TestResult>();

    public TestConclusion getOverallTestConclusion() {
        if (this.testResults.isEmpty()) {
            return TestConclusion.NO_RESULT;
        }
        long failed = this.testResults.stream().filter(testResult -> testResult.getTestConclusion().equals((Object)TestConclusion.FAIL)).count();
        if (failed > 0L) {
            return TestConclusion.FAIL;
        }
        return TestConclusion.PASS;
    }

    public void add(TestResult testResult) {
        testResult.setTestReport(this);
        this.testResults.add(testResult);
    }

    public void remove(int index) {
        this.testResults.remove(0);
    }

    public TestReport(@NonNull UUID id, @NonNull String detail) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (detail == null) {
            throw new NullPointerException("detail is marked non-null but is null");
        }
        this.id = id;
        this.detail = detail;
    }

    @Generated
    protected TestReport() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestReport)) {
            return false;
        }
        TestReport other = (TestReport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TestReport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getDetail() {
        return this.detail;
    }

    @Generated
    public void setDetail(@NonNull String detail) {
        if (detail == null) {
            throw new NullPointerException("detail is marked non-null but is null");
        }
        this.detail = detail;
    }

    @Generated
    public List<TestResult> getTestResults() {
        return this.testResults;
    }
}

