/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.testsupport;

import ch.admin.bit.jeap.testagent.api.notification.NotificationDto;
import ch.admin.bit.jeap.testagent.api.prepare.PreparationDto;
import ch.admin.bit.jeap.testorchestrator.domain.events.ExecuteDoneEvent;
import ch.admin.bit.jeap.testorchestrator.domain.events.NotificationEvent;
import ch.admin.bit.jeap.testorchestrator.services.TestCaseBaseInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class TestCaseRunner
implements ApplicationEventPublisher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestCaseRunner.class);
    private static final String CALLBACK_URL = "localhost://dummy/callback";
    private final String testId = UUID.randomUUID().toString();
    private TestcaseRunState testcaseRunState = TestcaseRunState.READY;
    private TestCaseBaseInterface testCase;
    private List<CompletableFuture<?>> tasks = new ArrayList();
    private CompletableFuture<Void> asyncRunCompletableFuture;

    public void run(TestCaseBaseInterface testCase) {
        if (this.testcaseRunState != TestcaseRunState.READY) {
            throw new IllegalStateException("A TestCaseRunner instance can only run one test, i.e. start() can only be called once.");
        }
        this.testcaseRunState = TestcaseRunState.STARTED;
        this.testCase = testCase;
        testCase.prepare(this.testId, this.createPreparationDto());
        testCase.execute(this.testId);
    }

    public CompletableFuture<Void> runAsync(TestCaseBaseInterface testCase) {
        this.asyncRunCompletableFuture = new CompletableFuture();
        CompletableFuture<Void> runTask = CompletableFuture.runAsync(() -> this.run(testCase));
        this.addTask(runTask);
        runTask.thenRun(this::completeAsyncRunIfAllTasksDone);
        return this.asyncRunCompletableFuture;
    }

    public boolean hasFinished() {
        return this.testcaseRunState == TestcaseRunState.FINISHED;
    }

    public String getTestId() {
        return this.testId;
    }

    public String getCallbackUrl() {
        return CALLBACK_URL;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this;
    }

    public void notify(NotificationDto notificationDto) {
        log.debug("Notifying test case with '{}' notification and data '{}' from '{}'.", new Object[]{notificationDto.getNotification(), notificationDto.getData(), notificationDto.getProducer()});
        this.testCase.onApplicationEvent(new NotificationEvent(this, notificationDto));
    }

    public void notifyAsync(NotificationDto notificationDto, long delay, TimeUnit unit) {
        if (this.asyncRunCompletableFuture == null) {
            throw new IllegalStateException("Thou shalt not call notifyAsync() outside of an async run.");
        }
        log.debug("Scheduling asynchronous notification '{}' with data '{}' from '{}' with delay of {} {}.", new Object[]{notificationDto.getNotification(), notificationDto.getData(), notificationDto.getProducer(), delay, unit});
        CompletableFuture<Void> notifyTask = CompletableFuture.runAsync(() -> this.notify(notificationDto), CompletableFuture.delayedExecutor(delay, unit));
        this.addTask(notifyTask);
        notifyTask.thenRun(this::completeAsyncRunIfAllTasksDone);
    }

    public void publishEvent(Object event) {
        if (event instanceof ExecuteDoneEvent) {
            ExecuteDoneEvent executeDoneEvent = (ExecuteDoneEvent)((Object)event);
            if (!this.testCase.getTestCaseName().equals(executeDoneEvent.getTestCaseName())) {
                throw new IllegalArgumentException("ExecuteDoneEvent's test case name does not match name of the test case under test.");
            }
            if (!this.testId.equals(executeDoneEvent.getTestId())) {
                throw new IllegalArgumentException("ExecuteDoneEvent's test id does not match the test id of this test run.");
            }
            log.debug("Got ExecuteDoneEvent event, ending execute phase and progressing to verify and clean-up phases.");
            this.finish();
        }
    }

    private void finish() {
        log.debug("Entering verify and clean-up phases.");
        this.testCase.verify(this.testId);
        this.testCase.cleanUp(this.testId);
        this.testcaseRunState = TestcaseRunState.FINISHED;
    }

    private void completeAsyncRunIfAllTasksDone() {
        if (this.allTasksDone()) {
            log.debug("All tasks done, completing async run future.");
            this.asyncRunCompletableFuture.complete(null);
        }
    }

    private synchronized void addTask(CompletableFuture<Void> task) {
        this.tasks.add(task);
    }

    private synchronized boolean allTasksDone() {
        return this.tasks.stream().allMatch(CompletableFuture::isDone);
    }

    private PreparationDto createPreparationDto() {
        return PreparationDto.builder().callbackBaseUrl(CALLBACK_URL).testCase(this.testCase.getTestCaseName()).build();
    }

    private static enum TestcaseRunState {
        READY,
        STARTED,
        FINISHED;

    }
}

