/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.services;

import ch.admin.bit.jeap.testorchestrator.adapter.jpa.TestRunJpaRepository;
import ch.admin.bit.jeap.testorchestrator.domain.TestCase;
import ch.admin.bit.jeap.testorchestrator.domain.TestConclusion;
import ch.admin.bit.jeap.testorchestrator.domain.TestReport;
import ch.admin.bit.jeap.testorchestrator.domain.TestResult;
import ch.admin.bit.jeap.testorchestrator.domain.TestRun;
import ch.admin.bit.jeap.testorchestrator.domain.TestState;
import ch.admin.bit.jeap.testorchestrator.services.TestCaseBaseInterface;
import ch.admin.bit.jeap.testorchestrator.services.TestReportService;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class TestRunService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestRunService.class);
    protected Map<String, TestCaseBaseInterface> testCasesMap;
    private final TestReportService testReportService;
    private final TestRunJpaRepository testRunJpaRepository;
    private final PlatformTransactionManager transactionManager;
    @Value(value="${orchestrator.testRunTimeout:30000}")
    private long testRunTimeout;

    public String getParameterValue(String testId, String key) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (String)transactionTemplate.execute(transactionStatus -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            return testRun.getParameters().get(key);
        });
    }

    public Map<String, String> getParameters(String testId) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (Map)transactionTemplate.execute(transactionStatus -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            return Map.copyOf(testRun.getParameters());
        });
    }

    public void setParameter(String testId, String key, String value) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.executeWithoutResult(status -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            testRun.getParameters().put(key, value);
            this.testRunJpaRepository.save(testRun);
        });
    }

    public void endTestRun(String testId) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.executeWithoutResult(status -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            testRun.setEndedAt(ZonedDateTime.now());
            testRun.setTestState(TestState.ENDED);
            this.testRunJpaRepository.save(testRun);
        });
    }

    public void abortTestRun(String testId, String message) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.executeWithoutResult(status -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            TestCaseBaseInterface testInstance = this.getTestInstance(testRun.getTestCase().getName());
            try {
                testInstance.verify(testId);
            }
            catch (Exception e) {
                log.error("TestRun {} wasn't verified correctly due to error {}", (Object)testId, (Object)e);
            }
            TestReport testReport = testRun.getTestReport();
            if (testReport != null) {
                List<TestResult> testResults = testReport.getTestResults();
                String testResultDetail = String.format(testId, message, testResults.get(0).getDetail());
                testReport.remove(0);
                testReport.setDetail(testResultDetail);
            } else {
                testReport = new TestReport(UUID.fromString(testId), "TestId: " + testId + "; Test was aborted. Reason: " + message);
            }
            testRun.setEndedAt(ZonedDateTime.now());
            testRun.setTestState(TestState.ABORTED);
            testRun.setTestReport(testReport);
            this.testRunJpaRepository.save(testRun);
            try {
                this.testReportService.reportToJira(testId);
                testInstance.cleanUp(testId);
            }
            catch (Exception e) {
                log.error("TestRun {} wasn't cleaned up correctly due to error {}", (Object)testId, (Object)e);
            }
        });
    }

    public void abortLongRunningTestRun(String testId) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.executeWithoutResult(status -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            TestState testState = testRun.getTestState();
            if (testState.equals((Object)TestState.STARTED)) {
                TestCaseBaseInterface testInstance = this.getTestInstance(testRun.getTestCase().getName());
                try {
                    testInstance.verify(testId);
                }
                catch (Exception e) {
                    log.error("TestRun {} wasn't verified correctly due to error {}", (Object)testId, (Object)e);
                }
                TestReport testReport = testRun.getTestReport();
                if (testReport != null) {
                    List<TestResult> testResults = testReport.getTestResults();
                    String testResultDetail = String.format(testId, this.testRunTimeout / 1000L, testResults.get(0).getDetail());
                    testReport.remove(0);
                    testReport.setDetail(testResultDetail);
                } else {
                    testReport = new TestReport(UUID.fromString(testId), "TestId: " + testId + "; The test lasted too long (>" + this.testRunTimeout / 1000L + " seconds) --&gt; Aborted");
                }
                testRun.setEndedAt(ZonedDateTime.now());
                testRun.setTestState(TestState.ABORTED);
                testRun.setTestReport(testReport);
                this.testRunJpaRepository.save(testRun);
                try {
                    this.testReportService.reportToJira(testId);
                    testInstance.cleanUp(testId);
                }
                catch (Exception e) {
                    log.error("TestRun {} wasn't cleaned up correctly due to error {}", (Object)testId, (Object)e);
                }
            }
        });
    }

    public boolean isTestRunInProgress(String testId) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return Boolean.TRUE.equals(transactionTemplate.execute(transactionStatus -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            return TestState.STARTED.equals((Object)testRun.getTestState());
        }));
    }

    public TestConclusion getOverallTestConclusion(String testId) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (TestConclusion)((Object)transactionTemplate.execute(transactionStatus -> {
            TestRun testRun = (TestRun)this.testRunJpaRepository.getReferenceById(UUID.fromString(testId));
            if (testRun.getTestReport() == null) {
                return TestConclusion.NO_RESULT;
            }
            return testRun.getTestReport().getOverallTestConclusion();
        }));
    }

    TestRun createTestRun(String zephyrEnvironment, TestCase actualTestCase) {
        TestRun newTestRun = new TestRun(zephyrEnvironment, actualTestCase);
        return (TestRun)this.testRunJpaRepository.save(newTestRun);
    }

    public TestCaseBaseInterface getTestInstance(String testCaseName) {
        return this.testCasesMap.get(testCaseName);
    }

    @Generated
    public TestRunService(TestReportService testReportService, TestRunJpaRepository testRunJpaRepository, PlatformTransactionManager transactionManager) {
        this.testReportService = testReportService;
        this.testRunJpaRepository = testRunJpaRepository;
        this.transactionManager = transactionManager;
    }

    @Generated
    public void setTestCasesMap(Map<String, TestCaseBaseInterface> testCasesMap) {
        this.testCasesMap = testCasesMap;
    }
}

