/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.testorchestrator.domain;

import ch.admin.bit.jeap.testorchestrator.domain.TestCase;
import ch.admin.bit.jeap.testorchestrator.domain.TestLog;
import ch.admin.bit.jeap.testorchestrator.domain.TestReport;
import ch.admin.bit.jeap.testorchestrator.domain.TestState;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class TestRun {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestRun.class);
    @Id
    private final UUID id = UUID.randomUUID();
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private TestState testState;
    @NonNull
    private ZonedDateTime startedAt;
    private ZonedDateTime endedAt;
    private String environment;
    @ManyToOne
    @JoinColumn(name="test_case_id")
    private TestCase testCase;
    @ElementCollection
    @CollectionTable(name="test_run_parameters", joinColumns={@JoinColumn(name="id")})
    @MapKeyColumn(name="name")
    @Column(name="value_")
    private Map<String, String> parameters = new HashMap<String, String>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="testRun")
    private List<TestLog> testLogs = new ArrayList<TestLog>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="test_report_id", referencedColumnName="id")
    private TestReport testReport;

    public TestRun(String environment, TestCase testCase) {
        this.testState = TestState.STARTED;
        this.startedAt = ZonedDateTime.now();
        this.environment = Objects.requireNonNullElse(environment, "");
        this.testCase = Objects.requireNonNull(testCase);
    }

    public String getTestId() {
        return this.id.toString();
    }

    public void add(TestLog testLog) {
        testLog.setTestRun(this);
        this.testLogs.add(testLog);
    }

    public void endTestRun(TestState testState) {
        if (testState != TestState.STARTED) {
            this.setTestState(testState);
            this.setEndedAt(ZonedDateTime.now());
        } else {
            log.warn("Trying to endTestRun {} with State STARTED. That makes no sense.", (Object)StructuredArguments.keyValue((String)"testId", (Object)this.id));
        }
    }

    @Generated
    protected TestRun() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRun)) {
            return false;
        }
        TestRun other = (TestRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TestRun;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public TestState getTestState() {
        return this.testState;
    }

    @NonNull
    @Generated
    public ZonedDateTime getStartedAt() {
        return this.startedAt;
    }

    @Generated
    public ZonedDateTime getEndedAt() {
        return this.endedAt;
    }

    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Generated
    public TestCase getTestCase() {
        return this.testCase;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public List<TestLog> getTestLogs() {
        return this.testLogs;
    }

    @Generated
    public TestReport getTestReport() {
        return this.testReport;
    }

    @Generated
    public void setTestState(@NonNull TestState testState) {
        if (testState == null) {
            throw new NullPointerException("testState is marked non-null but is null");
        }
        this.testState = testState;
    }

    @Generated
    public void setEndedAt(ZonedDateTime endedAt) {
        this.endedAt = endedAt;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setTestLogs(List<TestLog> testLogs) {
        this.testLogs = testLogs;
    }

    @Generated
    public void setTestReport(TestReport testReport) {
        this.testReport = testReport;
    }
}

