/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.starter.awskms;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.api.KeyId;
import ch.admin.bit.jeap.crypto.api.KeyIdCryptoService;
import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.api.KeyReferenceCryptoService;
import ch.admin.bit.jeap.crypto.starter.awskms.JeapCryptoAwsKmsConfigProperties;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;

class JeapAwsKmsKeyIdCryptoService
implements KeyIdCryptoService {
    private final JeapCryptoAwsKmsConfigProperties jeapCryptoAwsKmsConfigProperties;
    private final KeyReferenceCryptoService keyReferenceCryptoService;
    private final Set<KeyId> configuredKeyIds;

    JeapAwsKmsKeyIdCryptoService(JeapCryptoAwsKmsConfigProperties jeapCryptoAwsKmsConfigProperties, @Qualifier(value="awsKms") KeyReferenceCryptoService keyReferenceCryptoService) {
        this.jeapCryptoAwsKmsConfigProperties = jeapCryptoAwsKmsConfigProperties;
        this.configuredKeyIds = jeapCryptoAwsKmsConfigProperties.getKeys().keySet().stream().map(KeyId::of).collect(Collectors.toSet());
        this.keyReferenceCryptoService = keyReferenceCryptoService;
    }

    public byte[] encrypt(byte[] plaintext, KeyId keyId) {
        KeyReference keyReference = this.getKeyReferenceForKeyId(keyId).orElseThrow(() -> CryptoException.unknownKeyId((KeyId)keyId));
        return this.keyReferenceCryptoService.encrypt(plaintext, keyReference);
    }

    public byte[] decrypt(byte[] ciphertextCryptoContainer) {
        return this.keyReferenceCryptoService.decrypt(ciphertextCryptoContainer);
    }

    public Set<KeyId> configuredKeyIds() {
        return this.configuredKeyIds;
    }

    private Optional<KeyReference> getKeyReferenceForKeyId(KeyId keyId) {
        return Optional.ofNullable(this.jeapCryptoAwsKmsConfigProperties.getKeys().get(keyId.id())).map(JeapCryptoAwsKmsConfigProperties.AwsKmsKeyConfigProperties::getKeyReference);
    }

    public boolean canDecrypt(byte[] ciphertext) {
        return this.keyReferenceCryptoService.canDecrypt(ciphertext);
    }
}

