/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.starter.awskms;

import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.escrow.EscrowKeyType;
import ch.admin.bit.jeap.crypto.internal.core.escrow.PublicKeyParser;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementCachingConfigProperties;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.security.PublicKey;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import software.amazon.awssdk.regions.Region;

@ConfigurationProperties(prefix="jeap.crypto.awskms")
class JeapCryptoAwsKmsConfigProperties
implements KeyManagementCachingConfigProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapCryptoAwsKmsConfigProperties.class);
    static final String PROPERTY_PREFIX = "jeap.crypto.awskms";
    private Map<String, AwsKmsKeyConfigProperties> keys = Map.of();
    private Duration defaultEncryptionKeyCacheExpiryDuration = Duration.ofHours(1L);
    private Duration defaultDecryptionKeyCacheExpiryDuration = Duration.ofHours(6L);
    private long encryptionKeyMaxCacheSize = 100L;
    private long decryptionKeyMaxCacheSize = 50000L;
    private String region;
    private String endpoint;
    private EscrowKeyProperties defaultEscrowKey;
    private transient Map<KeyReference, Duration> encryptionKeyCacheExpiryDurations = new HashMap<KeyReference, Duration>();
    private transient Map<KeyReference, Duration> decryptionKeyCacheExpiryDurations = new HashMap<KeyReference, Duration>();
    @Autowired
    private transient Environment environment;

    JeapCryptoAwsKmsConfigProperties() {
    }

    public URI getEndpoint() {
        return this.endpoint == null ? null : URI.create(this.endpoint);
    }

    public Region getRegion() {
        if (this.region != null) {
            return Region.of((String)this.region);
        }
        String regionFromEnv = this.environment.getProperty("AWS_REGION");
        if (regionFromEnv == null) {
            throw new IllegalStateException("Region not provided in jeap.crypto.awskms.region or in AWS_REGION");
        }
        return Region.of((String)regionFromEnv);
    }

    public Duration getEncryptionKeyCacheExpiryDuration(KeyReference keyReference) {
        return this.encryptionKeyCacheExpiryDurations.getOrDefault(keyReference, this.defaultEncryptionKeyCacheExpiryDuration);
    }

    public Duration getDecryptionKeyCacheExpiryDuration(KeyReference keyReference) {
        return this.decryptionKeyCacheExpiryDurations.getOrDefault(keyReference, this.defaultDecryptionKeyCacheExpiryDuration);
    }

    @PostConstruct
    void postProcessConfiguration() {
        this.validateAndPrepareDefaultEscrowKey();
        this.validateAndPrepareKeys();
        log.debug("jEAP Crypto AWS KMS Configuration: " + String.valueOf(this));
    }

    private void validateAndPrepareKeys() {
        this.keys.forEach((keyName, keyProps) -> {
            KeyReference keyReference = keyProps.getKeyReference();
            Optional.ofNullable(keyProps.getEncryptionCacheExpiryDuration()).ifPresent(duration -> this.encryptionKeyCacheExpiryDurations.put(keyReference, (Duration)duration));
            Optional.ofNullable(keyProps.getDecryptionCacheExpiryDuration()).ifPresent(duration -> this.decryptionKeyCacheExpiryDurations.put(keyReference, (Duration)duration));
            if (keyProps.hasEscrowKey() && keyProps.getEscrowKey().getPublicKey() == null) {
                throw new IllegalStateException("Encryption key jeap.crypto.awskms.%s has an escrow key set, but no public key configured".formatted(keyName));
            }
            if (keyProps.hasEscrowKey()) {
                keyProps.escrowKey.parsedPublicKey = PublicKeyParser.parsePublicKey((String)keyProps.escrowKey.publicKey);
            }
        });
    }

    private void validateAndPrepareDefaultEscrowKey() {
        if (this.defaultEscrowKey != null && this.defaultEscrowKey.publicKey != null) {
            this.defaultEscrowKey.parsedPublicKey = PublicKeyParser.parsePublicKey((String)this.defaultEscrowKey.publicKey);
        }
        boolean cryptoDisabled = Boolean.parseBoolean(this.environment.getProperty("jeap.crypto.disabledForTestEnv", "false"));
        boolean anyKeyRequiresDefaultEscrowKey = this.keys.values().stream().anyMatch(v -> v.getEscrowKey() == null);
        if (!cryptoDisabled && anyKeyRequiresDefaultEscrowKey && (this.defaultEscrowKey == null || this.defaultEscrowKey.keyType != EscrowKeyType.NONE && this.defaultEscrowKey.publicKey == null)) {
            throw new IllegalStateException("The AWS KMS configuration under jeap.crypto.awskms is missing a default escrow key");
        }
    }

    public String toString() {
        return "JeapCryptoAwsKmsConfigProperties{keys=" + String.valueOf(this.keys) + ", defaultEncryptionKeyCacheExpiryDuration=" + String.valueOf(this.defaultEncryptionKeyCacheExpiryDuration) + ", defaultDecryptionKeyCacheExpiryDuration=" + String.valueOf(this.defaultDecryptionKeyCacheExpiryDuration) + ", encryptionKeyMaxCacheSize=" + this.encryptionKeyMaxCacheSize + ", decryptionKeyMaxCacheSize=" + this.decryptionKeyMaxCacheSize + ", region='" + this.region + "', endpoint='" + this.endpoint + "'}";
    }

    @Generated
    public Map<String, AwsKmsKeyConfigProperties> getKeys() {
        return this.keys;
    }

    @Generated
    public Duration getDefaultEncryptionKeyCacheExpiryDuration() {
        return this.defaultEncryptionKeyCacheExpiryDuration;
    }

    @Generated
    public Duration getDefaultDecryptionKeyCacheExpiryDuration() {
        return this.defaultDecryptionKeyCacheExpiryDuration;
    }

    @Generated
    public long getEncryptionKeyMaxCacheSize() {
        return this.encryptionKeyMaxCacheSize;
    }

    @Generated
    public long getDecryptionKeyMaxCacheSize() {
        return this.decryptionKeyMaxCacheSize;
    }

    @Generated
    public EscrowKeyProperties getDefaultEscrowKey() {
        return this.defaultEscrowKey;
    }

    @Generated
    public Map<KeyReference, Duration> getEncryptionKeyCacheExpiryDurations() {
        return this.encryptionKeyCacheExpiryDurations;
    }

    @Generated
    public Map<KeyReference, Duration> getDecryptionKeyCacheExpiryDurations() {
        return this.decryptionKeyCacheExpiryDurations;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public void setKeys(Map<String, AwsKmsKeyConfigProperties> keys) {
        this.keys = keys;
    }

    @Generated
    public void setDefaultEncryptionKeyCacheExpiryDuration(Duration defaultEncryptionKeyCacheExpiryDuration) {
        this.defaultEncryptionKeyCacheExpiryDuration = defaultEncryptionKeyCacheExpiryDuration;
    }

    @Generated
    public void setDefaultDecryptionKeyCacheExpiryDuration(Duration defaultDecryptionKeyCacheExpiryDuration) {
        this.defaultDecryptionKeyCacheExpiryDuration = defaultDecryptionKeyCacheExpiryDuration;
    }

    @Generated
    public void setEncryptionKeyMaxCacheSize(long encryptionKeyMaxCacheSize) {
        this.encryptionKeyMaxCacheSize = encryptionKeyMaxCacheSize;
    }

    @Generated
    public void setDecryptionKeyMaxCacheSize(long decryptionKeyMaxCacheSize) {
        this.decryptionKeyMaxCacheSize = decryptionKeyMaxCacheSize;
    }

    @Generated
    public void setRegion(String region) {
        this.region = region;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setDefaultEscrowKey(EscrowKeyProperties defaultEscrowKey) {
        this.defaultEscrowKey = defaultEscrowKey;
    }

    @Generated
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public static class EscrowKeyProperties {
        String publicKey;
        PublicKey parsedPublicKey;
        EscrowKeyType keyType = EscrowKeyType.RSA_4096;

        @Generated
        public EscrowKeyProperties() {
        }

        @Generated
        public String getPublicKey() {
            return this.publicKey;
        }

        @Generated
        public PublicKey getParsedPublicKey() {
            return this.parsedPublicKey;
        }

        @Generated
        public EscrowKeyType getKeyType() {
            return this.keyType;
        }

        @Generated
        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Generated
        public void setParsedPublicKey(PublicKey parsedPublicKey) {
            this.parsedPublicKey = parsedPublicKey;
        }

        @Generated
        public void setKeyType(EscrowKeyType keyType) {
            this.keyType = keyType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EscrowKeyProperties)) {
                return false;
            }
            EscrowKeyProperties other = (EscrowKeyProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            PublicKey this$parsedPublicKey = this.getParsedPublicKey();
            PublicKey other$parsedPublicKey = other.getParsedPublicKey();
            if (this$parsedPublicKey == null ? other$parsedPublicKey != null : !this$parsedPublicKey.equals(other$parsedPublicKey)) {
                return false;
            }
            EscrowKeyType this$keyType = this.getKeyType();
            EscrowKeyType other$keyType = other.getKeyType();
            return !(this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EscrowKeyProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            PublicKey $parsedPublicKey = this.getParsedPublicKey();
            result = result * 59 + ($parsedPublicKey == null ? 43 : $parsedPublicKey.hashCode());
            EscrowKeyType $keyType = this.getKeyType();
            result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JeapCryptoAwsKmsConfigProperties.EscrowKeyProperties(publicKey=" + this.getPublicKey() + ", parsedPublicKey=" + String.valueOf(this.getParsedPublicKey()) + ", keyType=" + String.valueOf(this.getKeyType()) + ")";
        }
    }

    static class AwsKmsKeyConfigProperties {
        private String keyArn;
        private Duration encryptionCacheExpiryDuration;
        private Duration decryptionCacheExpiryDuration;
        private EscrowKeyProperties escrowKey = null;

        public boolean hasEscrowKey() {
            return this.escrowKey != null && this.escrowKey.keyType != EscrowKeyType.NONE;
        }

        KeyReference getKeyReference() {
            return new KeyReference(this.keyArn);
        }

        @Generated
        public AwsKmsKeyConfigProperties() {
        }

        @Generated
        public String getKeyArn() {
            return this.keyArn;
        }

        @Generated
        public Duration getEncryptionCacheExpiryDuration() {
            return this.encryptionCacheExpiryDuration;
        }

        @Generated
        public Duration getDecryptionCacheExpiryDuration() {
            return this.decryptionCacheExpiryDuration;
        }

        @Generated
        public EscrowKeyProperties getEscrowKey() {
            return this.escrowKey;
        }

        @Generated
        public void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Generated
        public void setEncryptionCacheExpiryDuration(Duration encryptionCacheExpiryDuration) {
            this.encryptionCacheExpiryDuration = encryptionCacheExpiryDuration;
        }

        @Generated
        public void setDecryptionCacheExpiryDuration(Duration decryptionCacheExpiryDuration) {
            this.decryptionCacheExpiryDuration = decryptionCacheExpiryDuration;
        }

        @Generated
        public void setEscrowKey(EscrowKeyProperties escrowKey) {
            this.escrowKey = escrowKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AwsKmsKeyConfigProperties)) {
                return false;
            }
            AwsKmsKeyConfigProperties other = (AwsKmsKeyConfigProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$keyArn = this.getKeyArn();
            String other$keyArn = other.getKeyArn();
            if (this$keyArn == null ? other$keyArn != null : !this$keyArn.equals(other$keyArn)) {
                return false;
            }
            Duration this$encryptionCacheExpiryDuration = this.getEncryptionCacheExpiryDuration();
            Duration other$encryptionCacheExpiryDuration = other.getEncryptionCacheExpiryDuration();
            if (this$encryptionCacheExpiryDuration == null ? other$encryptionCacheExpiryDuration != null : !((Object)this$encryptionCacheExpiryDuration).equals(other$encryptionCacheExpiryDuration)) {
                return false;
            }
            Duration this$decryptionCacheExpiryDuration = this.getDecryptionCacheExpiryDuration();
            Duration other$decryptionCacheExpiryDuration = other.getDecryptionCacheExpiryDuration();
            if (this$decryptionCacheExpiryDuration == null ? other$decryptionCacheExpiryDuration != null : !((Object)this$decryptionCacheExpiryDuration).equals(other$decryptionCacheExpiryDuration)) {
                return false;
            }
            EscrowKeyProperties this$escrowKey = this.getEscrowKey();
            EscrowKeyProperties other$escrowKey = other.getEscrowKey();
            return !(this$escrowKey == null ? other$escrowKey != null : !((Object)this$escrowKey).equals(other$escrowKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AwsKmsKeyConfigProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $keyArn = this.getKeyArn();
            result = result * 59 + ($keyArn == null ? 43 : $keyArn.hashCode());
            Duration $encryptionCacheExpiryDuration = this.getEncryptionCacheExpiryDuration();
            result = result * 59 + ($encryptionCacheExpiryDuration == null ? 43 : ((Object)$encryptionCacheExpiryDuration).hashCode());
            Duration $decryptionCacheExpiryDuration = this.getDecryptionCacheExpiryDuration();
            result = result * 59 + ($decryptionCacheExpiryDuration == null ? 43 : ((Object)$decryptionCacheExpiryDuration).hashCode());
            EscrowKeyProperties $escrowKey = this.getEscrowKey();
            result = result * 59 + ($escrowKey == null ? 43 : ((Object)$escrowKey).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JeapCryptoAwsKmsConfigProperties.AwsKmsKeyConfigProperties(keyArn=" + this.getKeyArn() + ", encryptionCacheExpiryDuration=" + String.valueOf(this.getEncryptionCacheExpiryDuration()) + ", decryptionCacheExpiryDuration=" + String.valueOf(this.getDecryptionCacheExpiryDuration()) + ", escrowKey=" + String.valueOf(this.getEscrowKey()) + ")";
        }
    }
}

