/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.awskms.key;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.awskms.key.AwsKmsEncryptedDataKey;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.ByteBufferUtil;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.AbstractEncryptedDataKeyFormat;
import ch.admin.bit.jeap.crypto.internal.core.model.EncryptedDataKey;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class AwsKmsEncryptedDataKeyFormat
extends AbstractEncryptedDataKeyFormat {
    private static final byte[] AWS_KMS_AES_256_PROVIDER_ID = "aka256".getBytes(StandardCharsets.UTF_8);
    private static final int AWS_KMS_DATA_KEY_FORMAT_ID = 1;
    private static final int AWS_KMS_DATA_KEY_FORMAT_LENGTH = 2;

    public byte[] format(EncryptedDataKey encryptedDataKey) {
        AwsKmsEncryptedDataKey awsKmsEncryptedDataKey = (AwsKmsEncryptedDataKey)encryptedDataKey;
        byte[] keyIdBytes = awsKmsEncryptedDataKey.keyId().getBytes(StandardCharsets.UTF_8);
        byte[] ciphertext = awsKmsEncryptedDataKey.ciphertext();
        int frameLength = AwsKmsEncryptedDataKeyFormat.frameLength(keyIdBytes, ciphertext);
        ByteBuffer byteBuffer = ByteBuffer.allocate(frameLength);
        ByteBufferUtil.writeUnsignedShort((ByteBuffer)byteBuffer, (int)frameLength);
        ByteBufferUtil.writeUnsignedShort((ByteBuffer)byteBuffer, (int)1);
        ByteBufferUtil.writeUnsignedShort((ByteBuffer)byteBuffer, (int)AWS_KMS_AES_256_PROVIDER_ID.length);
        byteBuffer.put(AWS_KMS_AES_256_PROVIDER_ID);
        ByteBufferUtil.writeUnsignedShort((ByteBuffer)byteBuffer, (int)keyIdBytes.length);
        byteBuffer.put(keyIdBytes);
        ByteBufferUtil.writeUnsignedShort((ByteBuffer)byteBuffer, (int)ciphertext.length);
        byteBuffer.put(ciphertext);
        return byteBuffer.array();
    }

    public AwsKmsEncryptedDataKey parse(ByteBuffer byteBuffer) {
        int frameLength = ByteBufferUtil.readUnsignedShort((ByteBuffer)byteBuffer);
        int dataFormatId = ByteBufferUtil.readUnsignedShort((ByteBuffer)byteBuffer);
        this.assertDataFormatId(dataFormatId);
        int keyProviderIdLength = ByteBufferUtil.readUnsignedShort((ByteBuffer)byteBuffer);
        byte[] keyProviderIdBytes = new byte[keyProviderIdLength];
        byteBuffer.get(keyProviderIdBytes);
        AwsKmsEncryptedDataKeyFormat.assertKeyProviderId(keyProviderIdBytes);
        int keyIdLength = ByteBufferUtil.readUnsignedShort((ByteBuffer)byteBuffer);
        byte[] keyIdBytes = new byte[keyIdLength];
        byteBuffer.get(keyIdBytes);
        int ciphertextLength = ByteBufferUtil.readUnsignedShort((ByteBuffer)byteBuffer);
        byte[] ciphertext = new byte[ciphertextLength];
        AwsKmsEncryptedDataKeyFormat.assertCorrectFrameLength(keyIdBytes, ciphertext, frameLength);
        byteBuffer.get(ciphertext);
        String keyId = new String(keyIdBytes, StandardCharsets.UTF_8);
        return new AwsKmsEncryptedDataKey(ciphertext, null, keyId);
    }

    private void assertDataFormatId(int dataFormatId) {
        if (dataFormatId != 1) {
            throw CryptoException.badDataKeyFormatIdentifier((int)dataFormatId);
        }
    }

    private static void assertCorrectFrameLength(byte[] keyIdBytes, byte[] ciphertext, int frameLength) {
        int expectedFrameLength = AwsKmsEncryptedDataKeyFormat.frameLength(keyIdBytes, ciphertext);
        if (frameLength != expectedFrameLength) {
            throw CryptoException.badFieldLength((String)"data key frame length", (int)frameLength, (int)expectedFrameLength);
        }
    }

    private static int frameLength(byte[] keyIdBytes, byte[] ciphertext) {
        return 10 + AWS_KMS_AES_256_PROVIDER_ID.length + keyIdBytes.length + ciphertext.length;
    }

    private static void assertKeyProviderId(byte[] keyProviderIdBytes) {
        if (!Arrays.equals(AWS_KMS_AES_256_PROVIDER_ID, keyProviderIdBytes)) {
            throw CryptoException.unknownProviderId((byte[])keyProviderIdBytes);
        }
    }

    public boolean canParse(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() < 4) {
            return false;
        }
        byteBuffer.position(byteBuffer.position() + 2);
        int formatId = ByteBufferUtil.readUnsignedShort((ByteBuffer)byteBuffer);
        return formatId == 1;
    }
}

