/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.awskms.client;

import ch.admin.bit.jeap.crypto.awskms.client.DataKeyResponse;
import jakarta.annotation.PreDestroy;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest;
import software.amazon.awssdk.services.kms.model.GenerateDataKeyResponse;

public class AwsKmsClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AwsKmsClient.class);
    private final KmsClient kmsClient;

    public AwsKmsClient(AwsCredentialsProvider awsCredentialsProvider, Region region) {
        this.kmsClient = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().region(region)).credentialsProvider(awsCredentialsProvider)).build();
    }

    public AwsKmsClient(AwsCredentialsProvider awsCredentialsProvider, Region region, URI endpointOverride) {
        this.kmsClient = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().region(region)).credentialsProvider(awsCredentialsProvider)).endpointOverride(endpointOverride)).build();
    }

    @PreDestroy
    void close() {
        this.kmsClient.close();
    }

    public DataKeyResponse createDataKey(String keyId) {
        GenerateDataKeyRequest request = (GenerateDataKeyRequest)GenerateDataKeyRequest.builder().keyId(keyId).keySpec("AES_256").build();
        GenerateDataKeyResponse response = this.kmsClient.generateDataKey(request);
        log.debug("Created a data key for key id '{}'", (Object)response.keyId());
        return new DataKeyResponse(response.keyId(), response.ciphertextBlob().asByteArray(), response.plaintext().asByteArray());
    }

    public byte[] decryptDataKey(byte[] ciphertextBlob) {
        DecryptRequest request = (DecryptRequest)DecryptRequest.builder().ciphertextBlob(SdkBytes.fromByteArray((byte[])ciphertextBlob)).build();
        DecryptResponse response = this.kmsClient.decrypt(request);
        return response.plaintext().asByteArray();
    }
}

