/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.dataformat;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.JeapCryptoDataFormat;
import ch.admin.bit.jeap.crypto.internal.core.model.JeapCryptoContainer;
import java.nio.ByteBuffer;

public abstract class AbstractJeapCryptoDataFormat
implements JeapCryptoDataFormat {
    private static final int AUTH_TAG_LENGTH = 16;
    private static final int NONCE_LENGTH = 12;
    private static final int AES_256_KEY_SIZE = 32;
    protected static final int NONCE_FIELD_LENGTH = 12;
    protected static final int DATA_KEY_FIELD_LENGTH = 60;

    @Override
    public final byte[] format(JeapCryptoContainer cryptoContainer) {
        ByteBuffer byteBuffer = this.formatToByteBuffer(cryptoContainer);
        AbstractJeapCryptoDataFormat.assertBufferHasNoRemainingBytes(byteBuffer);
        return byteBuffer.array();
    }

    protected abstract ByteBuffer formatToByteBuffer(JeapCryptoContainer var1);

    protected static void assertBufferHasNoRemainingBytes(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() != 0) {
            throw CryptoException.unexpectedBufferSize(byteBuffer.remaining());
        }
    }

    protected static byte[] getNonce(ByteBuffer byteBuffer) {
        byte[] nonce = new byte[12];
        byteBuffer.get(nonce);
        return nonce;
    }

    protected static byte[] getEncryptedDataKey(ByteBuffer byteBuffer) {
        byte[] encryptedDataKeyBytes = new byte[60];
        byteBuffer.get(encryptedDataKeyBytes);
        return encryptedDataKeyBytes;
    }

    protected static byte[] getCiphertext(ByteBuffer byteBuffer) {
        int ciphertextLength = byteBuffer.remaining();
        byte[] ciphertext = new byte[ciphertextLength];
        AbstractJeapCryptoDataFormat.assertCiphertextNotEmpty(ciphertextLength);
        byteBuffer.get(ciphertext);
        return ciphertext;
    }

    protected static void assertCiphertextNotEmpty(int ciphertextLength) {
        if (ciphertextLength < 1) {
            throw CryptoException.emptyCiphertext();
        }
    }

    protected static void assertFieldLength(byte[] bytes, int expectedLength, String fieldName) {
        int actualLength = bytes.length;
        if (actualLength != expectedLength) {
            throw CryptoException.badFieldLength(fieldName, actualLength, expectedLength);
        }
    }
}

