/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.aes;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.api.KeyReferenceCryptoService;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.JeapCryptoDataFormat;
import ch.admin.bit.jeap.crypto.internal.core.jca.CryptoAdapter;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementService;
import ch.admin.bit.jeap.crypto.internal.core.model.DataKey;
import ch.admin.bit.jeap.crypto.internal.core.model.DataKeyPair;
import ch.admin.bit.jeap.crypto.internal.core.model.EncryptedDataKey;
import ch.admin.bit.jeap.crypto.internal.core.model.JeapCryptoContainer;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesGcmCryptoService
implements KeyReferenceCryptoService {
    private static final int KEY_SIZE_BYTES = 32;
    private static final int TAG_LENGTH_BYTES = 16;
    private static final int NONCE_LENGTH_BYTES = 12;
    private static final String AES = "AES";
    private static final String CRYPTO_ALGO = "AES/GCM/NoPadding";
    private final KeyManagementService keyManagementService;
    private final JeapCryptoDataFormat dataFormat;

    public AesGcmCryptoService(KeyManagementService keyManagementService, JeapCryptoDataFormat dataFormat) {
        this.keyManagementService = keyManagementService;
        this.dataFormat = dataFormat;
    }

    @Override
    public byte[] encrypt(byte[] plaintext, KeyReference wrappingKeyReference) {
        if (plaintext.length == 0) {
            throw CryptoException.emptyPlaintext();
        }
        JeapCryptoContainer container = this.encryptToContainer(plaintext, wrappingKeyReference);
        return this.dataFormat.format(container);
    }

    private JeapCryptoContainer encryptToContainer(byte[] data, KeyReference keyReference) {
        DataKeyPair dataKeyPair = this.keyManagementService.getDataKey(keyReference);
        SecretKey secretKey = this.createSecretKeyFromPlaintextKey(dataKeyPair.dataKey());
        byte[] nonce = dataKeyPair.dataKey().generateNonce(12);
        byte[] ciphertext = AesGcmCryptoService.encrypt(data, secretKey, nonce);
        return new JeapCryptoContainer(dataKeyPair.encryptedDataKey(), nonce, ciphertext);
    }

    @Override
    public byte[] decrypt(byte[] cryptoContainerBytes) {
        JeapCryptoContainer cryptoContainer = this.dataFormat.parse(cryptoContainerBytes);
        return this.decryptFromContainer(cryptoContainer);
    }

    private byte[] decryptFromContainer(JeapCryptoContainer cryptoContainer) {
        byte[] nonce = cryptoContainer.nonce();
        KeyReference keyReference = this.getKeyReferenceForDecryption(cryptoContainer.encryptedDataKey());
        SecretKey secretKey = this.createSecretKeyFromEncryptedDataKey(keyReference, cryptoContainer.encryptedDataKey());
        return this.decrypt(secretKey, nonce, cryptoContainer.ciphertext());
    }

    protected KeyReference getKeyReferenceForDecryption(EncryptedDataKey encryptedDataKey) {
        return encryptedDataKey.requireWrappingKeyReference();
    }

    private SecretKey createSecretKeyFromPlaintextKey(DataKey dataKey) {
        byte[] plaintextDataKey = dataKey.plaintextDataKey();
        return AesGcmCryptoService.createSecretKey(plaintextDataKey);
    }

    private SecretKey createSecretKeyFromEncryptedDataKey(KeyReference keyReference, EncryptedDataKey dataKey) {
        byte[] plaintextDataKey = this.keyManagementService.decryptDataKey(keyReference, dataKey);
        return AesGcmCryptoService.createSecretKey(plaintextDataKey);
    }

    private static SecretKeySpec createSecretKey(byte[] plaintextDataKey) {
        if (plaintextDataKey == null) {
            throw CryptoException.nullKey();
        }
        if (plaintextDataKey.length != 32) {
            throw CryptoException.badKeySize(plaintextDataKey.length, 32);
        }
        return new SecretKeySpec(plaintextDataKey, AES);
    }

    private static byte[] encrypt(byte[] data, SecretKey dataKey, byte[] nonce) {
        try {
            GCMParameterSpec params = AesGcmCryptoService.getGcmParameterSpec(nonce);
            Cipher cipher = CryptoAdapter.createCipher(CRYPTO_ALGO);
            cipher.init(1, (Key)dataKey, params);
            return cipher.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw CryptoException.encryptionFailed(e);
        }
    }

    private static GCMParameterSpec getGcmParameterSpec(byte[] nonce) {
        return new GCMParameterSpec(128, nonce);
    }

    private byte[] decrypt(SecretKey key, byte[] nonce, byte[] cipherText) {
        try {
            Cipher cipher = CryptoAdapter.createCipher(CRYPTO_ALGO);
            GCMParameterSpec params = AesGcmCryptoService.getGcmParameterSpec(nonce);
            cipher.init(2, (Key)key, params);
            return cipher.doFinal(cipherText);
        }
        catch (GeneralSecurityException e) {
            throw CryptoException.decryptionFailed(e);
        }
    }

    @Override
    public boolean canDecrypt(byte[] ciphertext) {
        return this.dataFormat.canParse(ciphertext);
    }
}

