/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.aes;

import ch.admin.bit.jeap.crypto.api.CryptoService;
import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.aes.AesGcmCryptoService;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.JeapCryptoDataFormat;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementService;
import ch.admin.bit.jeap.crypto.internal.core.model.EncryptedDataKey;
import java.util.Objects;

class ConfiguredKeyAesGcmCryptoService
implements CryptoService {
    private final AesGcmCryptoService delegate;
    private final KeyReference wrappingKeyReference;

    ConfiguredKeyAesGcmCryptoService(KeyManagementService keyManagementService, KeyReference wrappingKeyReference, JeapCryptoDataFormat dataFormat) {
        Objects.requireNonNull(wrappingKeyReference, "wrappingKeyReference");
        this.delegate = new AesGcmCryptoServiceWithConfiguredDecryptionKey(keyManagementService, wrappingKeyReference, dataFormat);
        this.wrappingKeyReference = wrappingKeyReference;
    }

    @Override
    public byte[] encrypt(byte[] plaintext) {
        return this.delegate.encrypt(plaintext, this.wrappingKeyReference);
    }

    @Override
    public byte[] decrypt(byte[] ciphertextCryptoContainer) {
        return this.delegate.decrypt(ciphertextCryptoContainer);
    }

    private static class AesGcmCryptoServiceWithConfiguredDecryptionKey
    extends AesGcmCryptoService {
        private final KeyReference wrappingKeyReference;

        private AesGcmCryptoServiceWithConfiguredDecryptionKey(KeyManagementService keyManagementService, KeyReference wrappingKeyReference, JeapCryptoDataFormat dataFormat) {
            super(keyManagementService, dataFormat);
            this.wrappingKeyReference = wrappingKeyReference;
        }

        @Override
        protected KeyReference getKeyReferenceForDecryption(EncryptedDataKey encryptedDataKey) {
            return this.wrappingKeyReference;
        }
    }
}

