/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.keymanagement;

import ch.admin.bit.jeap.crypto.internal.core.dataformat.ByteBufferUtil;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.EncryptedDataKeyFormat;
import ch.admin.bit.jeap.crypto.internal.core.model.EscrowDataKey;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public abstract class AbstractEncryptedDataKeyFormat
implements EncryptedDataKeyFormat {
    private static final int ESCROW_DATA_KEY_FORMAT_ID = 100;

    @Override
    public byte[] format(EscrowDataKey escrowDataKey) {
        byte[] ciphertext = escrowDataKey.ciphertext();
        byte[] escrowKeyType = escrowDataKey.escrowKeyType().keyTypeId().getBytes(StandardCharsets.UTF_8);
        int frameLength = 8 + escrowKeyType.length + ciphertext.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(frameLength);
        ByteBufferUtil.writeUnsignedShort(byteBuffer, frameLength);
        ByteBufferUtil.writeUnsignedShort(byteBuffer, 100);
        ByteBufferUtil.writeUnsignedShort(byteBuffer, escrowKeyType.length);
        byteBuffer.put(escrowKeyType);
        ByteBufferUtil.writeUnsignedShort(byteBuffer, ciphertext.length);
        byteBuffer.put(ciphertext);
        return byteBuffer.array();
    }
}

