/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.keymanagement;

import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.model.EncryptedDataKey;
import ch.admin.bit.jeap.crypto.internal.core.model.EscrowDataKey;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractEncryptedDataKey
implements EncryptedDataKey {
    private final byte[] ciphertext;
    private final EscrowDataKey escrowDataKey;
    private final KeyReference wrappingKeyReference;

    public AbstractEncryptedDataKey(byte[] ciphertext, EscrowDataKey escrowDataKey, KeyReference wrappingKeyReference) {
        this.ciphertext = ciphertext;
        this.escrowDataKey = escrowDataKey;
        this.wrappingKeyReference = wrappingKeyReference;
    }

    @Override
    public final byte[] ciphertext() {
        return this.ciphertext;
    }

    @Override
    public KeyReference wrappingKeyReference() {
        return this.wrappingKeyReference;
    }

    @Override
    public Optional<EscrowDataKey> escrowDataKey() {
        return Optional.ofNullable(this.escrowDataKey);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{wrappingKeyReference=" + String.valueOf(this.wrappingKeyReference) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEncryptedDataKey that = (AbstractEncryptedDataKey)o;
        return Arrays.equals(this.ciphertext, that.ciphertext) && Objects.equals(this.wrappingKeyReference, that.wrappingKeyReference);
    }

    public int hashCode() {
        int result = Objects.hash(this.wrappingKeyReference);
        result = 31 * result + Arrays.hashCode(this.ciphertext);
        return result;
    }
}

