/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.keymanagement;

import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.CryptoMetricsService;
import ch.admin.bit.jeap.crypto.internal.core.model.DataKeyPair;
import com.github.benmanes.caffeine.cache.Cache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import lombok.Generated;

public class MicrometerMetricsService
implements CryptoMetricsService {
    private static final Tag WITH_ESCROW_TAG = Tag.of((String)"escrow", (String)"true");
    private static final Tag WITHOUT_ESCROW_TAG = Tag.of((String)"escrow", (String)"false");
    private final MeterRegistry meterRegistry;

    @Override
    public <K, V> void enableCacheMetrics(Cache<K, V> cache, String cacheName) {
        CaffeineCacheMetrics.monitor((MeterRegistry)this.meterRegistry, cache, (String)cacheName, (String[])new String[0]);
    }

    @Override
    public void enableNoopEncryptionMetric(boolean isNoop) {
        this.meterRegistry.gauge("jeap_crypto_noop", (Number)(isNoop ? 1 : 0));
    }

    @Override
    public void countKeyUsedForEncryption(KeyReference key, DataKeyPair dataKeyPair) {
        boolean escrow = dataKeyPair.encryptedDataKey().escrowDataKey().isPresent();
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"key", (String)key.keyLocation()), escrow ? WITH_ESCROW_TAG : WITHOUT_ESCROW_TAG});
        this.meterRegistry.counter("jeap_crypto_key_encrypt", (Iterable)tags).increment();
    }

    @Override
    public void countKeyUsedForDecryption(KeyReference key) {
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"key", (String)key.keyLocation())});
        this.meterRegistry.counter("jeap_crypto_key_decrypt", (Iterable)tags).increment();
    }

    @Generated
    public MicrometerMetricsService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }
}

