/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.model;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public final class DataKey {
    private static final Random SECURE_RANDOM = new SecureRandom();
    private final AtomicLong nonceCounter = new AtomicLong(SECURE_RANDOM.nextLong());
    private final byte[] plaintextDataKey;

    public DataKey(byte[] plaintextDataKey) {
        Objects.requireNonNull(plaintextDataKey, "plaintextDataKey");
        this.plaintextDataKey = plaintextDataKey;
    }

    public byte[] plaintextDataKey() {
        return this.plaintextDataKey;
    }

    public final byte[] generateNonce(int nonceLengthBytes) {
        if (nonceLengthBytes < 8) {
            throw new IllegalArgumentException("Requested nonce length in bytes must be at least %s (was %s)".formatted(8, nonceLengthBytes));
        }
        long counterValue = this.nonceCounter.incrementAndGet();
        byte[] nonce = new byte[nonceLengthBytes];
        int length = 8;
        int offset = nonceLengthBytes - length;
        ByteBuffer.wrap(nonce, offset, length).putLong(counterValue);
        return nonce;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataKey dataKey = (DataKey)o;
        return Arrays.equals(this.plaintextDataKey, dataKey.plaintextDataKey);
    }

    public int hashCode() {
        return Arrays.hashCode(this.plaintextDataKey);
    }
}

