/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.api;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.api.KeyId;
import ch.admin.bit.jeap.crypto.api.KeyIdCryptoService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CryptoServiceProvider {
    private final List<KeyIdCryptoService> keyIdCryptoServices;

    public CryptoServiceProvider(List<KeyIdCryptoService> keyIdCryptoServices) {
        this.keyIdCryptoServices = keyIdCryptoServices;
    }

    public KeyIdCryptoService getKeyIdCryptoService(KeyId keyId) {
        return this.keyIdCryptoServices.stream().filter(keyIdCryptoService -> keyIdCryptoService.knows(keyId)).findFirst().orElseThrow(() -> CryptoException.unknownKeyId(keyId));
    }

    public KeyIdCryptoService getKeyIdCryptoServiceForDecryption(byte[] originalBytes) {
        return this.keyIdCryptoServices.stream().filter(keyIdCryptoService -> keyIdCryptoService.canDecrypt(originalBytes)).findFirst().orElseThrow(CryptoException::unknownCiphertextFormat);
    }

    public Set<KeyId> configuredKeyIds() {
        return this.keyIdCryptoServices.stream().flatMap(keyIdCryptoService -> keyIdCryptoService.configuredKeyIds().stream()).collect(Collectors.toSet());
    }
}

