/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.jca;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CryptoAdapter.class);
    private static final String CORRETO_PROVIDER_NAME = "AmazonCorrettoCryptoProvider";
    private static boolean correttoEnabled;

    public static Cipher createCipher(String algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        if (correttoEnabled) {
            return Cipher.getInstance(algorithm, CORRETO_PROVIDER_NAME);
        }
        return Cipher.getInstance(algorithm);
    }

    public static KeyFactory getKeyFactoryInstance(String rsa) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (correttoEnabled) {
            return KeyFactory.getInstance("RSA", CORRETO_PROVIDER_NAME);
        }
        return KeyFactory.getInstance("RSA");
    }

    static {
        AmazonCorrettoCryptoProvider.install();
        try {
            AmazonCorrettoCryptoProvider.INSTANCE.assertHealthy();
            correttoEnabled = true;
        }
        catch (Throwable t) {
            log.error("Native corretto crypto provider is not available on this platform. Crypto performance will not be optimized.");
            correttoEnabled = false;
        }
    }
}

