/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.keymanagement;

import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.CryptoMetricsService;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyCacheStats;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementCachingConfigProperties;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementService;
import ch.admin.bit.jeap.crypto.internal.core.model.DataKeyPair;
import ch.admin.bit.jeap.crypto.internal.core.model.EncryptedDataKey;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class CachingKeyManagementService
implements KeyManagementService {
    private final KeyManagementService keyManagementService;
    private final KeyManagementCachingConfigProperties configProperties;
    private final CryptoMetricsService cryptoMetricsService;
    private Cache<KeyReference, DataKeyPair> encryptionKeyCache;
    private Cache<DecryptionDataKeyCacheKey, byte[]> decryptionKeyCache;

    public CachingKeyManagementService(KeyManagementService keyManagementService, KeyManagementCachingConfigProperties configProperties, CryptoMetricsService cryptoMetricsService) {
        this(keyManagementService, configProperties, cryptoMetricsService, () -> ((Ticker)Ticker.systemTicker()).read());
    }

    CachingKeyManagementService(KeyManagementService keyManagementService, KeyManagementCachingConfigProperties configProperties, CryptoMetricsService cryptoMetricsService, Supplier<Long> ticker) {
        this.keyManagementService = keyManagementService;
        this.configProperties = configProperties;
        this.cryptoMetricsService = cryptoMetricsService;
        this.initializeEncryptionKeyCache(ticker::get);
        this.initializeDecryptionKeyCache(ticker::get);
        this.initializeCachingMetrics(cryptoMetricsService);
    }

    @Override
    public DataKeyPair getDataKey(KeyReference wrappingKeyReference) {
        if (this.encryptionKeyCache == null || this.getEncryptionKeyExpiry(wrappingKeyReference).isZero()) {
            return this.keyManagementService.getDataKey(wrappingKeyReference);
        }
        return this.getDataKeyIfNotCached(wrappingKeyReference);
    }

    private DataKeyPair getDataKeyIfNotCached(KeyReference wrappingKeyReference) {
        DataKeyPair cachedKeyPair = (DataKeyPair)this.encryptionKeyCache.getIfPresent((Object)wrappingKeyReference);
        if (cachedKeyPair != null) {
            this.cryptoMetricsService.countKeyUsedForEncryption(wrappingKeyReference, cachedKeyPair);
            return cachedKeyPair;
        }
        return this.getNewDataKey(wrappingKeyReference);
    }

    private DataKeyPair getNewDataKey(KeyReference wrappingKeyReference) {
        DataKeyPair keyPair = this.keyManagementService.getDataKey(wrappingKeyReference);
        this.encryptionKeyCache.put((Object)wrappingKeyReference, (Object)keyPair);
        return keyPair;
    }

    @Override
    public byte[] decryptDataKey(KeyReference wrappingKeyReference, EncryptedDataKey dataKey) {
        if (this.decryptionKeyCache == null || this.getDecryptionKeyExpiry(wrappingKeyReference).isZero()) {
            return this.keyManagementService.decryptDataKey(wrappingKeyReference, dataKey);
        }
        return this.decryptDataKeyIfNotCached(wrappingKeyReference, dataKey);
    }

    private byte[] decryptDataKeyIfNotCached(KeyReference wrappingKeyReference, EncryptedDataKey dataKey) {
        DecryptionDataKeyCacheKey cacheKey = new DecryptionDataKeyCacheKey(wrappingKeyReference, dataKey);
        byte[] cachedDecryptedKey = (byte[])this.decryptionKeyCache.getIfPresent((Object)cacheKey);
        if (cachedDecryptedKey != null) {
            this.cryptoMetricsService.countKeyUsedForDecryption(wrappingKeyReference);
            return cachedDecryptedKey;
        }
        return this.decryptDataKey(wrappingKeyReference, dataKey, cacheKey);
    }

    private byte[] decryptDataKey(KeyReference wrappingKeyReference, EncryptedDataKey dataKey, DecryptionDataKeyCacheKey cacheKey) {
        byte[] plaintext = this.keyManagementService.decryptDataKey(wrappingKeyReference, dataKey);
        this.decryptionKeyCache.put((Object)cacheKey, (Object)plaintext);
        return plaintext;
    }

    public KeyCacheStats getEncryptionKeyCacheStats() {
        return this.getKeyCacheStats(this.encryptionKeyCache);
    }

    public KeyCacheStats getDecryptionKeyCacheStats() {
        return this.getKeyCacheStats(this.decryptionKeyCache);
    }

    private <K, V> KeyCacheStats getKeyCacheStats(Cache<K, V> cache) {
        CacheStats stats = cache.stats();
        return new KeyCacheStats(stats.hitCount(), stats.missCount(), stats.evictionCount());
    }

    private void initializeEncryptionKeyCache(Ticker ticker) {
        if (this.configProperties.getEncryptionKeyMaxCacheSize() > 0L) {
            this.encryptionKeyCache = Caffeine.newBuilder().maximumSize(this.configProperties.getEncryptionKeyMaxCacheSize()).expireAfter((Expiry)new EncryptionKeyExpiry(this::getEncryptionKeyExpiry)).recordStats().ticker(ticker).build();
        }
    }

    private void initializeDecryptionKeyCache(Ticker ticker) {
        if (this.configProperties.getDecryptionKeyMaxCacheSize() > 0L) {
            this.decryptionKeyCache = Caffeine.newBuilder().maximumSize(this.configProperties.getDecryptionKeyMaxCacheSize()).expireAfter((Expiry)new DecryptionKeyExpiry(this::getDecryptionKeyExpiry)).recordStats().ticker(ticker).build();
        }
    }

    private void initializeCachingMetrics(CryptoMetricsService cryptoMetricsService) {
        cryptoMetricsService.enableCacheMetrics(this.encryptionKeyCache, "jeap-crypto-encryption-keys");
        cryptoMetricsService.enableCacheMetrics(this.decryptionKeyCache, "jeap-crypto-decryption-keys");
    }

    private Duration getEncryptionKeyExpiry(KeyReference keyReference) {
        return this.configProperties.getEncryptionKeyCacheExpiryDuration(keyReference);
    }

    private Duration getDecryptionKeyExpiry(KeyReference keyReference) {
        return this.configProperties.getDecryptionKeyCacheExpiryDuration(keyReference);
    }

    private record DecryptionDataKeyCacheKey(KeyReference keyReference, EncryptedDataKey dataKey) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DecryptionDataKeyCacheKey that = (DecryptionDataKeyCacheKey)o;
            return Objects.equals(this.keyReference, that.keyReference) && Arrays.equals(this.dataKey.ciphertext(), that.dataKey.ciphertext());
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.keyReference);
            result = 31 * result + Arrays.hashCode(this.dataKey.ciphertext());
            return result;
        }
    }

    private record EncryptionKeyExpiry(Function<KeyReference, Duration> expireAfterCreateDurationFunction) implements Expiry<KeyReference, DataKeyPair>
    {
        public long expireAfterCreate(KeyReference keyReference, DataKeyPair value, long currentTime) {
            return this.expireAfterCreateDurationFunction.apply(keyReference).toNanos();
        }

        public long expireAfterUpdate(KeyReference key, DataKeyPair value, long currentTime, long currentDuration) {
            return currentDuration;
        }

        public long expireAfterRead(KeyReference key, DataKeyPair value, long currentTime, long currentDuration) {
            return currentDuration;
        }
    }

    private record DecryptionKeyExpiry(Function<KeyReference, Duration> expireAfterCreateDurationFunction) implements Expiry<DecryptionDataKeyCacheKey, byte[]>
    {
        public long expireAfterCreate(DecryptionDataKeyCacheKey decryptDataKeyCacheKey, byte[] value, long currentTime) {
            return this.expireAfterCreateDurationFunction.apply(decryptDataKeyCacheKey.keyReference()).toNanos();
        }

        public long expireAfterUpdate(DecryptionDataKeyCacheKey key, byte[] value, long currentTime, long currentDuration) {
            return currentDuration;
        }

        public long expireAfterRead(DecryptionDataKeyCacheKey key, byte[] value, long currentTime, long currentDuration) {
            return currentDuration;
        }
    }
}

