/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.internal.core.escrow;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.internal.core.escrow.EscrowEncryptedDataKey;
import ch.admin.bit.jeap.crypto.internal.core.escrow.EscrowEncryptionService;
import ch.admin.bit.jeap.crypto.internal.core.escrow.EscrowKeyType;
import ch.admin.bit.jeap.crypto.internal.core.model.DataKey;
import ch.admin.bit.jeap.crypto.internal.core.model.EscrowDataKey;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.PublicKey;
import javax.crypto.Cipher;

public class AsymmetricEscrowEncryptionService
implements EscrowEncryptionService {
    static final String RSA_TRANSFORMATION = "RSA/ECB/OAEPPadding";

    @Override
    public EscrowDataKey encryptEscrowDataKey(DataKey DataKey2, EscrowKeyType escrowKeyType, PublicKey escrowPublicKey) {
        if (escrowKeyType == EscrowKeyType.NONE) {
            return null;
        }
        try {
            byte[] ciphertext = this.encrypt(DataKey2.plaintextDataKey(), escrowKeyType, escrowPublicKey);
            return new EscrowEncryptedDataKey(ciphertext, escrowKeyType);
        }
        catch (GeneralSecurityException exception) {
            throw CryptoException.generalSecurityException("Failed to encrypt escrow data key", exception);
        }
    }

    private byte[] encrypt(byte[] plaintext, EscrowKeyType escrowKeyType, PublicKey escrowPublicKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.transformation(escrowKeyType), (Provider)AmazonCorrettoCryptoProvider.INSTANCE);
        cipher.init(1, escrowPublicKey);
        cipher.update(plaintext);
        return cipher.doFinal();
    }

    private String transformation(EscrowKeyType escrowKeyType) {
        if (escrowKeyType == EscrowKeyType.RSA_4096) {
            return RSA_TRANSFORMATION;
        }
        throw CryptoException.unknownEscrowKeyType(escrowKeyType);
    }

    static {
        AmazonCorrettoCryptoProvider.install();
        AmazonCorrettoCryptoProvider.INSTANCE.assertHealthy();
    }
}

