/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.s3;

import ch.admin.bit.jeap.crypto.api.CryptoService;
import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.api.KeyReferenceCryptoService;
import ch.admin.bit.jeap.crypto.s3.JeapDecryptedS3Object;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class JeapCryptoS3Template {
    private static final String METADATA_KEY_IS_ENCRYPTED = "is_encrypted";
    private final S3Client s3Client;
    private final Function<byte[], byte[]> encryptionFunction;
    private final Function<byte[], byte[]> decryptionFunction;

    public JeapCryptoS3Template(S3Client s3Client, KeyReferenceCryptoService keyReferenceCryptoService, KeyReference keyReference) {
        this.s3Client = s3Client;
        this.encryptionFunction = plaintext -> keyReferenceCryptoService.encrypt(plaintext, keyReference);
        this.decryptionFunction = arg_0 -> ((KeyReferenceCryptoService)keyReferenceCryptoService).decrypt(arg_0);
    }

    public JeapCryptoS3Template(S3Client s3Client, CryptoService cryptoService) {
        this.s3Client = s3Client;
        this.encryptionFunction = arg_0 -> ((CryptoService)cryptoService).encrypt(arg_0);
        this.decryptionFunction = arg_0 -> ((CryptoService)cryptoService).decrypt(arg_0);
    }

    public void putObject(String bucketName, String objectKey, byte[] plainTextByteArray) {
        this.putObject(bucketName, objectKey, plainTextByteArray, Map.of());
    }

    public void putObject(String bucketName, String keyName, byte[] plainTextByteArray, Map<String, String> userMetaDataMap) {
        byte[] encryptedText = this.encryptionFunction.apply(plainTextByteArray);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(METADATA_KEY_IS_ENCRYPTED, Boolean.TRUE.toString());
        metadata.putAll(userMetaDataMap);
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(keyName).metadata(metadata).build();
        this.s3Client.putObject(putObjectRequest, RequestBody.fromBytes((byte[])encryptedText));
    }

    public JeapDecryptedS3Object getObject(String bucketName, String keyName) {
        return this.getObject(bucketName, keyName, null);
    }

    public JeapDecryptedS3Object getObject(String bucketName, String keyName, String versionId) {
        HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().key(keyName).bucket(bucketName).build();
        Map metadata = this.s3Client.headObject(headObjectRequest).metadata();
        boolean isEncrypted = JeapCryptoS3Template.isObjectEncrypted(metadata);
        GetObjectRequest.Builder requestBuilder = GetObjectRequest.builder().key(keyName).bucket(bucketName);
        if (versionId != null) {
            requestBuilder.versionId(versionId);
        }
        GetObjectRequest objectRequest = (GetObjectRequest)requestBuilder.build();
        ResponseBytes objectBytes = this.s3Client.getObjectAsBytes(objectRequest);
        byte[] objectContent = objectBytes.asByteArray();
        byte[] decryptedText = isEncrypted ? this.decryptionFunction.apply(objectContent) : objectContent;
        return JeapDecryptedS3Object.of(bucketName, keyName, versionId, metadata, decryptedText);
    }

    private static boolean isObjectEncrypted(Map<String, String> metadata) {
        if (metadata.containsKey(METADATA_KEY_IS_ENCRYPTED)) {
            return Boolean.parseBoolean(metadata.get(METADATA_KEY_IS_ENCRYPTED));
        }
        return false;
    }
}

