/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.spring;

import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.JeapCryptoDataFormat;
import ch.admin.bit.jeap.crypto.spring.BeanNames;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public abstract class AbstractCryptoBeanDefinitionRegistryPostProcessor
implements EnvironmentAware,
BeanDefinitionRegistryPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCryptoBeanDefinitionRegistryPostProcessor.class);
    static final String CRYPTO_SERVICE_BEAN_NAME_POSTFIX = "CryptoService";
    protected Environment environment;

    protected void registerBeans(BeanDefinitionRegistry registry, String keyId, KeyReference keyReference, JeapCryptoDataFormat dataFormat, String kmsBeanName) {
        String cryptoServiceBeanName = BeanNames.beanNameFromKeyId(keyId, CRYPTO_SERVICE_BEAN_NAME_POSTFIX);
        log.info("Registering crypto service bean {} for key id {} at {}", new Object[]{cryptoServiceBeanName, keyId, keyReference});
        AbstractCryptoBeanDefinitionRegistryPostProcessor.registerCryptoServiceBean(cryptoServiceBeanName, registry, keyReference, dataFormat, kmsBeanName);
    }

    private static void registerCryptoServiceBean(String beanName, BeanDefinitionRegistry registry, KeyReference keyReference, JeapCryptoDataFormat dataFormat, String kmsBeanName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName("ch.admin.bit.jeap.crypto.internal.core.aes.ConfiguredKeyAesGcmCryptoService");
        ConstructorArgumentValues constructorArgs = new ConstructorArgumentValues();
        constructorArgs.addGenericArgumentValue((Object)new RuntimeBeanReference(kmsBeanName));
        constructorArgs.addGenericArgumentValue((Object)keyReference);
        constructorArgs.addGenericArgumentValue((Object)dataFormat);
        beanDefinition.setConstructorArgumentValues(constructorArgs);
        beanDefinition.setLazyInit(true);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

