/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.spring;

import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ConditionalOnProperty(value={"jeap.crypto.disabledForTestEnv"})
public class JeapCryptoNoopValidationAutoConfiguration {
    private final Environment environment;

    @PostConstruct
    public void assertValidConfiguration() {
        if (this.isAbnOrProd()) {
            throw new IllegalStateException("Encryption is disabled by property jeap.crypto.disabledForTestEnv. This must not be enabled for abn or prod environment.");
        }
    }

    private boolean isAbnOrProd() {
        return Arrays.stream(this.environment.getActiveProfiles()).anyMatch(profile -> profile.equalsIgnoreCase("abn") || profile.equalsIgnoreCase("prod"));
    }

    @Generated
    public JeapCryptoNoopValidationAutoConfiguration(Environment environment) {
        this.environment = environment;
    }
}

