/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.spring;

import ch.admin.bit.jeap.crypto.api.CryptoException;
import ch.admin.bit.jeap.crypto.api.CryptoServiceProvider;
import ch.admin.bit.jeap.crypto.api.KeyId;
import ch.admin.bit.jeap.crypto.api.KeyIdCryptoService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class JeapCryptoCommonAutoConfiguration {
    private final List<KeyIdCryptoService> keyIdCryptoServices;

    public JeapCryptoCommonAutoConfiguration(List<KeyIdCryptoService> keyIdCryptoServices) {
        this.keyIdCryptoServices = keyIdCryptoServices;
    }

    @Bean
    CryptoServiceProvider cryptoServiceProvider() {
        return new CryptoServiceProvider(this.keyIdCryptoServices);
    }

    @PostConstruct
    void validateNoDuplicateKeyIds() {
        this.keyIdCryptoServices.stream().flatMap(keyIdCryptoService -> keyIdCryptoService.configuredKeyIds().stream()).collect(Collectors.groupingBy(keyId -> keyId)).values().stream().filter(keyIdList -> keyIdList.size() > 1).findFirst().ifPresent(keyIds -> this.throwDuplicateKeyIdException((KeyId)keyIds.get(0)));
    }

    private void throwDuplicateKeyIdException(KeyId keyId) {
        throw CryptoException.duplicateKeyId((KeyId)keyId);
    }
}

