/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.starter.vault;

import ch.admin.bit.jeap.crypto.api.KeyReference;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementCachingConfigProperties;
import ch.admin.bit.jeap.crypto.vault.keymanagement.VaultKeyLocation;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(prefix="jeap.crypto.vault")
class JeapCryptoVaultConfigProperties
implements KeyManagementCachingConfigProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JeapCryptoVaultConfigProperties.class);
    static final String PROPERTY_PREFIX = "jeap.crypto.vault";
    private String defaultSecretEnginePath;
    private Map<String, VaultKeyConfigProperties> keys = Map.of();
    private Duration defaultEncryptionKeyCacheExpiryDuration = Duration.ofHours(1L);
    private Duration defaultDecryptionKeyCacheExpiryDuration = Duration.ofHours(6L);
    private long encryptionKeyMaxCacheSize = 100L;
    private long decryptionKeyMaxCacheSize = 50000L;
    private transient Map<KeyReference, Duration> encryptionKeyCacheExpiryDurations = new HashMap<KeyReference, Duration>();
    private transient Map<KeyReference, Duration> decryptionKeyCacheExpiryDurations = new HashMap<KeyReference, Duration>();
    @Autowired
    private transient Environment environment;

    JeapCryptoVaultConfigProperties() {
    }

    public Duration getEncryptionKeyCacheExpiryDuration(KeyReference keyReference) {
        return this.encryptionKeyCacheExpiryDurations.getOrDefault(keyReference, this.defaultEncryptionKeyCacheExpiryDuration);
    }

    public Duration getDecryptionKeyCacheExpiryDuration(KeyReference keyReference) {
        return this.decryptionKeyCacheExpiryDurations.getOrDefault(keyReference, this.defaultDecryptionKeyCacheExpiryDuration);
    }

    @PostConstruct
    void init() {
        this.postProcessConfiguration(this.environment);
    }

    void postProcessConfiguration(Environment environment) {
        if (this.defaultSecretEnginePath == null) {
            this.setDefaultSecretEnginePathFromVaultSystemName(environment);
        }
        this.keys.values().forEach(vaultKeyConfigProperties -> {
            if (vaultKeyConfigProperties.secretEnginePath == null) {
                this.assertDefaultSecretEnginePathAvailable();
                vaultKeyConfigProperties.secretEnginePath = this.defaultSecretEnginePath;
            }
            KeyReference keyReference = vaultKeyConfigProperties.getKeyReference();
            Optional.ofNullable(vaultKeyConfigProperties.getEncryptionCacheExpiryDuration()).ifPresent(duration -> this.encryptionKeyCacheExpiryDurations.put(keyReference, (Duration)duration));
            Optional.ofNullable(vaultKeyConfigProperties.getDecryptionCacheExpiryDuration()).ifPresent(duration -> this.decryptionKeyCacheExpiryDurations.put(keyReference, (Duration)duration));
        });
        log.debug("jEAP Crypto Vault Configuration: " + String.valueOf(this));
    }

    private void setDefaultSecretEnginePathFromVaultSystemName(Environment environment) {
        String vaultSystemName = environment.getProperty("jeap.vault.system-name");
        if (vaultSystemName != null) {
            this.defaultSecretEnginePath = "transit/" + vaultSystemName;
        }
    }

    private void assertDefaultSecretEnginePathAvailable() {
        if (this.defaultSecretEnginePath == null) {
            throw new IllegalArgumentException("Vault transit secret engine path must be set using the property %s.<key>.secret-engine-path or %s.default-secret-engine-path".formatted(PROPERTY_PREFIX, PROPERTY_PREFIX));
        }
    }

    public String toString() {
        return "JeapCryptoVaultConfigProperties{defaultSecretEnginePath='" + this.defaultSecretEnginePath + "', keys=" + String.valueOf(this.keys) + ", defaultEncryptionKeyCacheExpiryDuration=" + String.valueOf(this.defaultEncryptionKeyCacheExpiryDuration) + ", defaultDecryptionKeyCacheExpiryDuration=" + String.valueOf(this.defaultDecryptionKeyCacheExpiryDuration) + ", encryptionKeyMaxCacheSize=" + this.encryptionKeyMaxCacheSize + ", decryptionKeyMaxCacheSize=" + this.decryptionKeyMaxCacheSize + ", encryptionKeyCacheExpiryDurations=" + String.valueOf(this.encryptionKeyCacheExpiryDurations) + ", decryptionKeyCacheExpiryDurations=" + String.valueOf(this.decryptionKeyCacheExpiryDurations) + "}";
    }

    @Generated
    public String getDefaultSecretEnginePath() {
        return this.defaultSecretEnginePath;
    }

    @Generated
    public Map<String, VaultKeyConfigProperties> getKeys() {
        return this.keys;
    }

    @Generated
    public Duration getDefaultEncryptionKeyCacheExpiryDuration() {
        return this.defaultEncryptionKeyCacheExpiryDuration;
    }

    @Generated
    public Duration getDefaultDecryptionKeyCacheExpiryDuration() {
        return this.defaultDecryptionKeyCacheExpiryDuration;
    }

    @Generated
    public long getEncryptionKeyMaxCacheSize() {
        return this.encryptionKeyMaxCacheSize;
    }

    @Generated
    public long getDecryptionKeyMaxCacheSize() {
        return this.decryptionKeyMaxCacheSize;
    }

    @Generated
    public Map<KeyReference, Duration> getEncryptionKeyCacheExpiryDurations() {
        return this.encryptionKeyCacheExpiryDurations;
    }

    @Generated
    public Map<KeyReference, Duration> getDecryptionKeyCacheExpiryDurations() {
        return this.decryptionKeyCacheExpiryDurations;
    }

    @Generated
    public Environment getEnvironment() {
        return this.environment;
    }

    @Generated
    public void setDefaultSecretEnginePath(String defaultSecretEnginePath) {
        this.defaultSecretEnginePath = defaultSecretEnginePath;
    }

    @Generated
    public void setKeys(Map<String, VaultKeyConfigProperties> keys) {
        this.keys = keys;
    }

    @Generated
    public void setDefaultEncryptionKeyCacheExpiryDuration(Duration defaultEncryptionKeyCacheExpiryDuration) {
        this.defaultEncryptionKeyCacheExpiryDuration = defaultEncryptionKeyCacheExpiryDuration;
    }

    @Generated
    public void setDefaultDecryptionKeyCacheExpiryDuration(Duration defaultDecryptionKeyCacheExpiryDuration) {
        this.defaultDecryptionKeyCacheExpiryDuration = defaultDecryptionKeyCacheExpiryDuration;
    }

    @Generated
    public void setEncryptionKeyMaxCacheSize(long encryptionKeyMaxCacheSize) {
        this.encryptionKeyMaxCacheSize = encryptionKeyMaxCacheSize;
    }

    @Generated
    public void setDecryptionKeyMaxCacheSize(long decryptionKeyMaxCacheSize) {
        this.decryptionKeyMaxCacheSize = decryptionKeyMaxCacheSize;
    }

    static class VaultKeyConfigProperties {
        private String keyName;
        private String secretEnginePath;
        private Duration encryptionCacheExpiryDuration;
        private Duration decryptionCacheExpiryDuration;

        KeyReference getKeyReference() {
            return VaultKeyLocation.asKeyReference((String)this.secretEnginePath, (String)this.keyName);
        }

        @Generated
        public VaultKeyConfigProperties() {
        }

        @Generated
        public String getKeyName() {
            return this.keyName;
        }

        @Generated
        public String getSecretEnginePath() {
            return this.secretEnginePath;
        }

        @Generated
        public Duration getEncryptionCacheExpiryDuration() {
            return this.encryptionCacheExpiryDuration;
        }

        @Generated
        public Duration getDecryptionCacheExpiryDuration() {
            return this.decryptionCacheExpiryDuration;
        }

        @Generated
        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Generated
        public void setSecretEnginePath(String secretEnginePath) {
            this.secretEnginePath = secretEnginePath;
        }

        @Generated
        public void setEncryptionCacheExpiryDuration(Duration encryptionCacheExpiryDuration) {
            this.encryptionCacheExpiryDuration = encryptionCacheExpiryDuration;
        }

        @Generated
        public void setDecryptionCacheExpiryDuration(Duration decryptionCacheExpiryDuration) {
            this.decryptionCacheExpiryDuration = decryptionCacheExpiryDuration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VaultKeyConfigProperties)) {
                return false;
            }
            VaultKeyConfigProperties other = (VaultKeyConfigProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$keyName = this.getKeyName();
            String other$keyName = other.getKeyName();
            if (this$keyName == null ? other$keyName != null : !this$keyName.equals(other$keyName)) {
                return false;
            }
            String this$secretEnginePath = this.getSecretEnginePath();
            String other$secretEnginePath = other.getSecretEnginePath();
            if (this$secretEnginePath == null ? other$secretEnginePath != null : !this$secretEnginePath.equals(other$secretEnginePath)) {
                return false;
            }
            Duration this$encryptionCacheExpiryDuration = this.getEncryptionCacheExpiryDuration();
            Duration other$encryptionCacheExpiryDuration = other.getEncryptionCacheExpiryDuration();
            if (this$encryptionCacheExpiryDuration == null ? other$encryptionCacheExpiryDuration != null : !((Object)this$encryptionCacheExpiryDuration).equals(other$encryptionCacheExpiryDuration)) {
                return false;
            }
            Duration this$decryptionCacheExpiryDuration = this.getDecryptionCacheExpiryDuration();
            Duration other$decryptionCacheExpiryDuration = other.getDecryptionCacheExpiryDuration();
            return !(this$decryptionCacheExpiryDuration == null ? other$decryptionCacheExpiryDuration != null : !((Object)this$decryptionCacheExpiryDuration).equals(other$decryptionCacheExpiryDuration));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof VaultKeyConfigProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $keyName = this.getKeyName();
            result = result * 59 + ($keyName == null ? 43 : $keyName.hashCode());
            String $secretEnginePath = this.getSecretEnginePath();
            result = result * 59 + ($secretEnginePath == null ? 43 : $secretEnginePath.hashCode());
            Duration $encryptionCacheExpiryDuration = this.getEncryptionCacheExpiryDuration();
            result = result * 59 + ($encryptionCacheExpiryDuration == null ? 43 : ((Object)$encryptionCacheExpiryDuration).hashCode());
            Duration $decryptionCacheExpiryDuration = this.getDecryptionCacheExpiryDuration();
            result = result * 59 + ($decryptionCacheExpiryDuration == null ? 43 : ((Object)$decryptionCacheExpiryDuration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JeapCryptoVaultConfigProperties.VaultKeyConfigProperties(keyName=" + this.getKeyName() + ", secretEnginePath=" + this.getSecretEnginePath() + ", encryptionCacheExpiryDuration=" + String.valueOf(this.getEncryptionCacheExpiryDuration()) + ", decryptionCacheExpiryDuration=" + String.valueOf(this.getDecryptionCacheExpiryDuration()) + ")";
        }
    }
}

