/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.crypto.starter.vault;

import ch.admin.bit.jeap.crypto.api.KeyIdCryptoService;
import ch.admin.bit.jeap.crypto.api.KeyReferenceCryptoService;
import ch.admin.bit.jeap.crypto.internal.core.aes.AesGcmCryptoService;
import ch.admin.bit.jeap.crypto.internal.core.dataformat.JeapCryptoDataFormat;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.CachingKeyManagementService;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.CryptoMetricsService;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementCachingConfigProperties;
import ch.admin.bit.jeap.crypto.internal.core.keymanagement.KeyManagementService;
import ch.admin.bit.jeap.crypto.starter.vault.JeapCryptoVaultBeanDefinitionRegistryPostProcessor;
import ch.admin.bit.jeap.crypto.starter.vault.JeapCryptoVaultConfigProperties;
import ch.admin.bit.jeap.crypto.starter.vault.JeapVaultKeyIdCryptoService;
import ch.admin.bit.jeap.crypto.vault.format.JeapCryptoKeyReferenceDataFormat;
import ch.admin.bit.jeap.crypto.vault.keymanagement.VaultKeyManagementService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.vault.core.VaultOperations;

@AutoConfiguration
@EnableConfigurationProperties(value={JeapCryptoVaultConfigProperties.class})
@ConditionalOnProperty(value={"spring.cloud.vault.enabled"}, matchIfMissing=true)
public class JeapCryptoVaultAutoConfiguration {
    @Bean
    public static BeanDefinitionRegistryPostProcessor vaultBeanDefinitionRegistryPostProcessor() {
        return new JeapCryptoVaultBeanDefinitionRegistryPostProcessor();
    }

    @Qualifier(value="vault")
    @Bean
    public KeyManagementService vaultKeyManagementService(VaultOperations vaultOperations, JeapCryptoVaultConfigProperties jeapCryptoVaultConfigProperties, CryptoMetricsService cryptoMetricsService) {
        VaultKeyManagementService keyManagementService = new VaultKeyManagementService(vaultOperations, cryptoMetricsService);
        if (jeapCryptoVaultConfigProperties.getDecryptionKeyMaxCacheSize() == 0L && jeapCryptoVaultConfigProperties.getEncryptionKeyMaxCacheSize() == 0L) {
            return keyManagementService;
        }
        return new CachingKeyManagementService((KeyManagementService)keyManagementService, (KeyManagementCachingConfigProperties)jeapCryptoVaultConfigProperties, cryptoMetricsService);
    }

    @Qualifier(value="vault")
    @Bean
    public KeyReferenceCryptoService vaultKeyReferenceCryptoService(@Qualifier(value="vault") KeyManagementService keyManagementService) {
        JeapCryptoKeyReferenceDataFormat keyReferenceDataFormat = new JeapCryptoKeyReferenceDataFormat();
        return new AesGcmCryptoService(keyManagementService, (JeapCryptoDataFormat)keyReferenceDataFormat);
    }

    @Qualifier(value="vault")
    @Bean
    public KeyIdCryptoService vaultKeyIdCryptoService(JeapCryptoVaultConfigProperties jeapCryptoVaultConfigProperties, @Qualifier(value="vault") KeyReferenceCryptoService keyReferenceCryptoService) {
        return new JeapVaultKeyIdCryptoService(jeapCryptoVaultConfigProperties, keyReferenceCryptoService);
    }
}

